/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.service;

import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.UserTransaction;

import jp.sf.fess.Constants;
import jp.sf.fess.FessSystemException;
import jp.sf.fess.db.cbean.BrowserTypeCB;
import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.cbean.LabelTypeCB;
import jp.sf.fess.db.cbean.OverlappingHostCB;
import jp.sf.fess.db.cbean.PathMappingCB;
import jp.sf.fess.db.cbean.RequestHeaderCB;
import jp.sf.fess.db.cbean.RoleTypeCB;
import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.exbhv.BrowserTypeBhv;
import jp.sf.fess.db.exbhv.CrawlingSessionBhv;
import jp.sf.fess.db.exbhv.CrawlingSessionInfoBhv;
import jp.sf.fess.db.exbhv.DataConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataCrawlingConfigBhv;
import jp.sf.fess.db.exbhv.FileConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileCrawlingConfigBhv;
import jp.sf.fess.db.exbhv.LabelTypeBhv;
import jp.sf.fess.db.exbhv.OverlappingHostBhv;
import jp.sf.fess.db.exbhv.PathMappingBhv;
import jp.sf.fess.db.exbhv.RequestHeaderBhv;
import jp.sf.fess.db.exbhv.RoleTypeBhv;
import jp.sf.fess.db.exbhv.WebAuthenticationBhv;
import jp.sf.fess.db.exbhv.WebConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebCrawlingConfigBhv;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.CrawlingSession;
import jp.sf.fess.db.exentity.CrawlingSessionInfo;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.db.exentity.OverlappingHost;
import jp.sf.fess.db.exentity.PathMapping;
import jp.sf.fess.db.exentity.RequestHeader;
import jp.sf.fess.db.exentity.RoleType;
import jp.sf.fess.db.exentity.WebAuthentication;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;
import jp.sf.fess.helper.LabelTypeHelper;
import jp.sf.fess.util.FessProperties;

import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseService implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = LoggerFactory
            .getLogger(DatabaseService.class);

    private static final String VERSION_KEY = "version";

    private static final String CRAWLER_PROPERTIES_KEY = "crawlerProperties";

    private static final String BROWSER_TYPE_KEY = "browserType";

    private static final String LABEL_TYPE_KEY = "labelType";

    private static final String ROLE_TYPE_KEY = "roleType";

    private static final String CRAWLING_SESSION_KEY = "crawlingSession";

    private static final String CRAWLING_SESSION_INFO_KEY = "crawlingSessionInfo";

    private static final String FILE_CRAWLING_CONFIG_KEY = "fileCrawlingConfig";

    private static final String DATA_CRAWLING_CONFIG_KEY = "dataCrawlingConfig";

    private static final String PATH_MAPPING_KEY = "pathMapping";

    private static final String WEB_CRAWLING_CONFIG_KEY = "webCrawlingConfig";

    private static final String FILE_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY = "fileConfigToBrowserTypeMapping";

    private static final String DATA_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY = "dataConfigToBrowserTypeMapping";

    private static final String WEB_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY = "webConfigToBrowserTypeMapping";

    private static final String FILE_CONFIG_TO_LABEL_TYPE_MAPPING_KEY = "fileConfigToLabelTypeMapping";

    private static final String DATA_CONFIG_TO_LABEL_TYPE_MAPPING_KEY = "dataConfigToLabelTypeMapping";

    private static final String WEB_CONFIG_TO_LABEL_TYPE_MAPPING_KEY = "webConfigToLabelTypeMapping";

    private static final String FILE_CONFIG_TO_ROLE_TYPE_MAPPING_KEY = "fileConfigToRoleTypeMapping";

    private static final String DATA_CONFIG_TO_ROLE_TYPE_MAPPING_KEY = "dataConfigToRoleTypeMapping";

    private static final String WEB_CONFIG_TO_ROLE_TYPE_MAPPING_KEY = "webConfigToRoleTypeMapping";

    private static final String WEB_AUTHENTICATION_KEY = "webAuthentication";

    private static final String REQUEST_HEADER_KEY = "requestHeader";

    private static final String OVERLAPPING_HOST_KEY = "overlappingHost";

    @Resource
    protected BrowserTypeBhv browserTypeBhv;

    @Resource
    protected LabelTypeBhv labelTypeBhv;

    @Resource
    protected RoleTypeBhv roleTypeBhv;

    @Resource
    protected CrawlingSessionBhv crawlingSessionBhv;

    @Resource
    protected CrawlingSessionInfoBhv crawlingSessionInfoBhv;

    @Resource
    protected FileCrawlingConfigBhv fileCrawlingConfigBhv;

    @Resource
    protected DataCrawlingConfigBhv dataCrawlingConfigBhv;

    @Resource
    protected PathMappingBhv pathMappingBhv;

    @Resource
    protected WebCrawlingConfigBhv webCrawlingConfigBhv;

    @Resource
    protected FileConfigToBrowserTypeMappingBhv fileConfigToBrowserTypeMappingBhv;

    @Resource
    protected DataConfigToBrowserTypeMappingBhv dataConfigToBrowserTypeMappingBhv;

    @Resource
    protected WebConfigToBrowserTypeMappingBhv webConfigToBrowserTypeMappingBhv;

    @Resource
    protected FileConfigToLabelTypeMappingBhv fileConfigToLabelTypeMappingBhv;

    @Resource
    protected DataConfigToLabelTypeMappingBhv dataConfigToLabelTypeMappingBhv;

    @Resource
    protected WebConfigToLabelTypeMappingBhv webConfigToLabelTypeMappingBhv;

    @Resource
    protected FileConfigToRoleTypeMappingBhv fileConfigToRoleTypeMappingBhv;

    @Resource
    protected DataConfigToRoleTypeMappingBhv dataConfigToRoleTypeMappingBhv;

    @Resource
    protected WebConfigToRoleTypeMappingBhv webConfigToRoleTypeMappingBhv;

    @Resource
    protected WebAuthenticationBhv webAuthenticationBhv;

    @Resource
    protected OverlappingHostBhv overlappingHostBhv;

    @Resource
    protected RequestHeaderBhv requestHeaderBhv;

    @Resource
    protected FessProperties crawlerProperties;

    @Resource
    public UserTransaction userTransaction;

    public static class DataSet implements Serializable {
        private static final long serialVersionUID = 1L;

        private Map<String, Object> dataMap = new HashMap<String, Object>();

        public void put(String key, Object value) {
            dataMap.put(key, value);
        }
    }

    public void exportData(OutputStream out) {
        if (out == null) {
            throw new FessSystemException("The output stream is null.");
        }

        Map<String, Object> dataSet = new HashMap<String, Object>();

        // version
        dataSet.put(VERSION_KEY, Constants.FESS_VERSION);

        // browserType
        BrowserTypeCB browserTypeCB = new BrowserTypeCB();
        browserTypeCB.query().setDeletedBy_IsNull();
        dataSet.put(BROWSER_TYPE_KEY + "List", browserTypeBhv
                .selectList(browserTypeCB));
        // labelType
        LabelTypeCB labelTypeCB = new LabelTypeCB();
        labelTypeCB.query().setDeletedBy_IsNull();
        dataSet.put(LABEL_TYPE_KEY + "List", labelTypeBhv
                .selectList(labelTypeCB));
        // roleType
        RoleTypeCB roleTypeCB = new RoleTypeCB();
        roleTypeCB.query().setDeletedBy_IsNull();
        dataSet.put(ROLE_TYPE_KEY + "List", roleTypeBhv.selectList(roleTypeCB));
        // crawlingSession
        dataSet.put(CRAWLING_SESSION_KEY + "List", crawlingSessionBhv
                .selectList(new CrawlingSessionCB()));
        // crawlingSessionInfo
        dataSet.put(CRAWLING_SESSION_INFO_KEY + "List", crawlingSessionInfoBhv
                .selectList(new CrawlingSessionInfoCB()));
        // fileCrawlingConfig
        FileCrawlingConfigCB fileCrawlingConfigCB = new FileCrawlingConfigCB();
        fileCrawlingConfigCB.query().setDeletedBy_IsNull();
        dataSet.put(FILE_CRAWLING_CONFIG_KEY + "List", fileCrawlingConfigBhv
                .selectList(fileCrawlingConfigCB));
        // dataCrawlingConfig
        DataCrawlingConfigCB dataCrawlingConfigCB = new DataCrawlingConfigCB();
        dataCrawlingConfigCB.query().setDeletedBy_IsNull();
        dataSet.put(DATA_CRAWLING_CONFIG_KEY + "List", dataCrawlingConfigBhv
                .selectList(dataCrawlingConfigCB));
        // pathMapping
        PathMappingCB pathMappingCB = new PathMappingCB();
        pathMappingCB.query().setDeletedBy_IsNull();
        dataSet.put(PATH_MAPPING_KEY + "List", pathMappingBhv
                .selectList(pathMappingCB));
        // overlappingHost
        OverlappingHostCB overlappingHostCB = new OverlappingHostCB();
        overlappingHostCB.query().setDeletedBy_IsNull();
        dataSet.put(OVERLAPPING_HOST_KEY + "List", overlappingHostBhv
                .selectList(overlappingHostCB));
        // webCrawlingConfig
        WebCrawlingConfigCB webCrawlingConfigCB = new WebCrawlingConfigCB();
        webCrawlingConfigCB.query().setDeletedBy_IsNull();
        dataSet.put(WEB_CRAWLING_CONFIG_KEY + "List", webCrawlingConfigBhv
                .selectList(webCrawlingConfigCB));
        // fileConfigToBrowserTypeMapping
        dataSet.put(FILE_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + "List",
                fileConfigToBrowserTypeMappingBhv
                        .selectList(new FileConfigToBrowserTypeMappingCB()));
        // dataConfigToBrowserTypeMapping
        dataSet.put(DATA_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + "List",
                dataConfigToBrowserTypeMappingBhv
                        .selectList(new DataConfigToBrowserTypeMappingCB()));
        // webConfigToBrowserTypeMapping
        dataSet.put(WEB_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + "List",
                webConfigToBrowserTypeMappingBhv
                        .selectList(new WebConfigToBrowserTypeMappingCB()));
        // fileConfigToLabelTypeMapping
        dataSet.put(FILE_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + "List",
                fileConfigToLabelTypeMappingBhv
                        .selectList(new FileConfigToLabelTypeMappingCB()));
        // dataConfigToLabelTypeMapping
        dataSet.put(DATA_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + "List",
                dataConfigToLabelTypeMappingBhv
                        .selectList(new DataConfigToLabelTypeMappingCB()));
        // webConfigToLabelTypeMapping
        dataSet.put(WEB_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + "List",
                webConfigToLabelTypeMappingBhv
                        .selectList(new WebConfigToLabelTypeMappingCB()));
        // fileConfigToRoleTypeMapping
        dataSet.put(FILE_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + "List",
                fileConfigToRoleTypeMappingBhv
                        .selectList(new FileConfigToRoleTypeMappingCB()));
        // dataConfigToRoleTypeMapping
        dataSet.put(DATA_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + "List",
                dataConfigToRoleTypeMappingBhv
                        .selectList(new DataConfigToRoleTypeMappingCB()));
        // webConfigToRoleTypeMapping
        dataSet.put(WEB_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + "List",
                webConfigToRoleTypeMappingBhv
                        .selectList(new WebConfigToRoleTypeMappingCB()));
        // webAuthentication
        dataSet.put(WEB_AUTHENTICATION_KEY + "List", webAuthenticationBhv
                .selectList(new WebAuthenticationCB()));
        // requestHeader
        dataSet.put(REQUEST_HEADER_KEY + "List", requestHeaderBhv
                .selectList(new RequestHeaderCB()));

        // crawlerProperties
        Map<String, String> crawlerPropertyMap = new HashMap<String, String>();
        crawlerPropertyMap.put(Constants.CRON_EXPRESSION_PROPERTY,
                crawlerProperties.getProperty(
                        Constants.CRON_EXPRESSION_PROPERTY,
                        Constants.DEFAULT_CRON_EXPRESSION));
        crawlerPropertyMap.put(Constants.OPTIMIZE_PROPERTY, crawlerProperties
                .getProperty(Constants.OPTIMIZE_PROPERTY, "true"));
        crawlerPropertyMap.put(Constants.COMMIT_PROPERTY, crawlerProperties
                .getProperty(Constants.COMMIT_PROPERTY, "true"));
        crawlerPropertyMap.put(Constants.SERVER_ROTATION_PROPERTY,
                crawlerProperties.getProperty(
                        Constants.SERVER_ROTATION_PROPERTY, "true"));
        crawlerPropertyMap.put(Constants.DAY_FOR_CLEANUP_PROPERTY,
                crawlerProperties.getProperty(
                        Constants.DAY_FOR_CLEANUP_PROPERTY, "1"));
        crawlerPropertyMap.put(Constants.COMMIT_PER_COUNT_PROPERTY,
                crawlerProperties.getProperty(
                        Constants.COMMIT_PER_COUNT_PROPERTY, Long
                                .toString(Constants.DEFAULT_COMMIT_PER_COUNT)));
        crawlerPropertyMap.put(Constants.CRAWLING_THREAD_COUNT_PROPERTY,
                crawlerProperties.getProperty(
                        Constants.CRAWLING_THREAD_COUNT_PROPERTY, "5"));
        crawlerPropertyMap.put(Constants.MOBILE_TRANSCODER_PROPERTY,
                crawlerProperties.getProperty(
                        Constants.MOBILE_TRANSCODER_PROPERTY,
                        Constants.EMPTY_STRING));
        dataSet.put(CRAWLER_PROPERTIES_KEY, crawlerPropertyMap);

        try {
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(out));
            PersistenceDelegate pd = encoder.getPersistenceDelegate(Date.class);
            encoder.setPersistenceDelegate(Timestamp.class, pd);
            encoder.writeObject(dataSet);
            encoder.close();
        } catch (Exception e) {
            throw new FessSystemException("Could not write a data set.", e);
        }
    }

    @TransactionAttribute(TransactionAttributeType.NEVER)
    public void importData(InputStream in, boolean overwrite) {
        if (in == null) {
            throw new FessSystemException("The input stream is null.");
        }

        Map<String, Object> dataSet;
        try {
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(in));
            dataSet = (Map<String, Object>) decoder.readObject();
        } catch (Exception e) {
            throw new FessSystemException("Could not read a data set.", e);
        }

        if (dataSet == null) {
            throw new FessSystemException("The object is null.");
        }

        // TODO check version

        new Thread(new DataImporter(dataSet, overwrite)).start();

    }

    protected class DataImporter implements Runnable {
        protected boolean overwrite;

        protected Map<String, Object> dataSet;

        protected DataImporter(Map<String, Object> dataSet, boolean overwrite) {
            this.dataSet = dataSet;
            this.overwrite = overwrite;
        }

        @Override
        public void run() {
            Map<String, Long> idMap = new HashMap<String, Long>();

            // browserType
            try {
                userTransaction.begin();

                List<BrowserType> browserTypeList = (List<BrowserType>) dataSet
                        .get(BROWSER_TYPE_KEY + "List");
                if (browserTypeList != null) {
                    for (BrowserType browserType : browserTypeList) {
                        Long id = browserType.getId();

                        BrowserTypeCB cb = new BrowserTypeCB();
                        cb.query().setValue_Equal(browserType.getValue());
                        cb.query().setDeletedBy_IsNull();
                        BrowserType entity = browserTypeBhv.selectEntity(cb);
                        browserType.setId(null);
                        if (entity == null) {
                            browserTypeBhv.insert(browserType);
                        } else {
                            // always overwrite
                            // if (overwrite) {
                            browserType.setVersionNo(null);
                            Beans.copy(browserType, entity).excludesNull()
                                    .execute();
                            browserType = entity;
                            browserTypeBhv.update(browserType);
                            // } else {
                            // browserTypeBhv.insert(browserType);
                            // }
                        }
                        idMap.put(BROWSER_TYPE_KEY + ":" + id.toString(),
                                browserType.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: " + BROWSER_TYPE_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // labelType
            try {
                userTransaction.begin();

                List<LabelType> labelTypeList = (List<LabelType>) dataSet
                        .get(LABEL_TYPE_KEY + "List");
                if (labelTypeList != null) {
                    for (LabelType labelType : labelTypeList) {
                        Long id = labelType.getId();

                        LabelTypeCB cb = new LabelTypeCB();
                        cb.query().setValue_Equal(labelType.getValue());
                        cb.query().setDeletedBy_IsNull();
                        LabelType entity = labelTypeBhv.selectEntity(cb);
                        labelType.setId(null);
                        if (entity == null) {
                            labelTypeBhv.insert(labelType);
                        } else {
                            // always overwrite
                            // if (overwrite) {
                            labelType.setVersionNo(null);
                            Beans.copy(labelType, entity).excludesNull()
                                    .execute();
                            labelType = entity;
                            labelTypeBhv.update(labelType);
                            // } else {
                            // labelTypeBhv.insert(labelType);
                            // }
                        }
                        idMap.put(LABEL_TYPE_KEY + ":" + id.toString(),
                                labelType.getId());
                    }
                }
                // restore labels
                LabelTypeHelper labelTypeHelper = SingletonS2Container
                        .getComponent("labelTypeHelper");
                if (labelTypeHelper != null) {
                    labelTypeHelper.init();
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: " + LABEL_TYPE_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            } // roleType
            try {
                userTransaction.begin();

                List<RoleType> roleTypeList = (List<RoleType>) dataSet
                        .get(ROLE_TYPE_KEY + "List");
                if (roleTypeList != null) {
                    for (RoleType roleType : roleTypeList) {
                        Long id = roleType.getId();

                        RoleTypeCB cb = new RoleTypeCB();
                        cb.query().setValue_Equal(roleType.getValue());
                        cb.query().setDeletedBy_IsNull();
                        RoleType entity = roleTypeBhv.selectEntity(cb);
                        roleType.setId(null);
                        if (entity == null) {
                            roleTypeBhv.insert(roleType);
                        } else {
                            // always overwrite
                            // if (overwrite) {
                            roleType.setVersionNo(null);
                            Beans.copy(roleType, entity).excludesNull()
                                    .execute();
                            roleType = entity;
                            roleTypeBhv.update(roleType);
                            // } else {
                            // roleTypeBhv.insert(roleType);
                            // }
                        }
                        idMap.put(ROLE_TYPE_KEY + ":" + id.toString(), roleType
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: " + ROLE_TYPE_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // crawlingSession
            try {
                userTransaction.begin();

                List<CrawlingSession> crawlingSessionList = (List<CrawlingSession>) dataSet
                        .get(CRAWLING_SESSION_KEY + "List");
                if (crawlingSessionList != null) {
                    for (CrawlingSession crawlingSession : crawlingSessionList) {
                        Long id = crawlingSession.getId();

                        CrawlingSessionCB cb = new CrawlingSessionCB();
                        cb.query().setSessionId_Equal(
                                crawlingSession.getSessionId());
                        CrawlingSession entity = crawlingSessionBhv
                                .selectEntity(cb);
                        crawlingSession.setId(null);
                        if (entity == null) {
                            crawlingSessionBhv.insert(crawlingSession);
                        } else {
                            Beans.copy(crawlingSession, entity).excludesNull()
                                    .execute();
                            crawlingSession = entity;
                            crawlingSessionBhv.update(crawlingSession);
                            // delete info
                            CrawlingSessionInfoCB cb2 = new CrawlingSessionInfoCB();
                            cb2.query().setCrawlingSessionId_Equal(
                                    crawlingSession.getId());
                            crawlingSessionInfoBhv.queryDelete(cb2);
                        }
                        idMap.put(CRAWLING_SESSION_KEY + ":" + id.toString(),
                                crawlingSession.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: " + CRAWLING_SESSION_KEY,
                        e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // crawlingSessionInfo
            try {
                userTransaction.begin();

                List<CrawlingSessionInfo> crawlingSessionInfoList = (List<CrawlingSessionInfo>) dataSet
                        .get(CRAWLING_SESSION_INFO_KEY + "List");
                if (crawlingSessionInfoList != null) {
                    for (CrawlingSessionInfo crawlingSessionInfo : crawlingSessionInfoList) {
                        Long id = crawlingSessionInfo.getId();
                        // relations
                        crawlingSessionInfo.setCrawlingSessionId(idMap
                                .get(CRAWLING_SESSION_KEY
                                        + ":"
                                        + crawlingSessionInfo
                                                .getCrawlingSessionId()));
                        crawlingSessionInfo.setId(null);
                        crawlingSessionInfoBhv.insert(crawlingSessionInfo);
                        idMap.put(CRAWLING_SESSION_INFO_KEY + ":"
                                + id.toString(), crawlingSessionInfo.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + CRAWLING_SESSION_INFO_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // fileCrawlingConfig
            try {
                userTransaction.begin();

                List<FileCrawlingConfig> fileCrawlingConfigList = (List<FileCrawlingConfig>) dataSet
                        .get(FILE_CRAWLING_CONFIG_KEY + "List");
                if (fileCrawlingConfigList != null) {
                    for (FileCrawlingConfig fileCrawlingConfig : fileCrawlingConfigList) {
                        Long id = fileCrawlingConfig.getId();

                        FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
                        cb.query().setName_Equal(fileCrawlingConfig.getName());
                        cb.query().setDeletedBy_IsNull();
                        FileCrawlingConfig entity = fileCrawlingConfigBhv
                                .selectEntity(cb);
                        fileCrawlingConfig.setId(null);
                        if (entity == null) {
                            fileCrawlingConfigBhv.insert(fileCrawlingConfig);
                        } else {
                            if (overwrite) {
                                fileCrawlingConfig.setVersionNo(null);
                                Beans.copy(fileCrawlingConfig, entity)
                                        .excludesNull().execute();
                                fileCrawlingConfig = entity;
                                fileCrawlingConfigBhv
                                        .update(fileCrawlingConfig);
                            } else {
                                fileCrawlingConfigBhv
                                        .insert(fileCrawlingConfig);
                            }
                        }
                        idMap.put(FILE_CRAWLING_CONFIG_KEY + ":"
                                + id.toString(), fileCrawlingConfig.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + FILE_CRAWLING_CONFIG_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // dataCrawlingConfig
            try {
                userTransaction.begin();

                List<DataCrawlingConfig> dataCrawlingConfigList = (List<DataCrawlingConfig>) dataSet
                        .get(DATA_CRAWLING_CONFIG_KEY + "List");
                if (dataCrawlingConfigList != null) {
                    for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
                        Long id = dataCrawlingConfig.getId();

                        DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
                        cb.query().setName_Equal(dataCrawlingConfig.getName());
                        cb.query().setDeletedBy_IsNull();
                        DataCrawlingConfig entity = dataCrawlingConfigBhv
                                .selectEntity(cb);
                        dataCrawlingConfig.setId(null);
                        if (entity == null) {
                            dataCrawlingConfigBhv.insert(dataCrawlingConfig);
                        } else {
                            if (overwrite) {
                                dataCrawlingConfig.setVersionNo(null);
                                Beans.copy(dataCrawlingConfig, entity)
                                        .excludesNull().execute();
                                dataCrawlingConfig = entity;
                                dataCrawlingConfigBhv
                                        .update(dataCrawlingConfig);
                            } else {
                                dataCrawlingConfigBhv
                                        .insert(dataCrawlingConfig);
                            }
                        }
                        idMap.put(DATA_CRAWLING_CONFIG_KEY + ":"
                                + id.toString(), dataCrawlingConfig.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + DATA_CRAWLING_CONFIG_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // pathMapping
            try {
                userTransaction.begin();

                List<PathMapping> pathMappingList = (List<PathMapping>) dataSet
                        .get(PATH_MAPPING_KEY + "List");
                if (pathMappingList != null) {
                    for (PathMapping pathMapping : pathMappingList) {
                        Long id = pathMapping.getId();

                        PathMappingCB cb = new PathMappingCB();
                        cb.query().setRegex_Equal(pathMapping.getRegex());
                        cb.query().setDeletedBy_IsNull();
                        PathMapping entity = pathMappingBhv.selectEntity(cb);
                        pathMapping.setId(null);
                        if (entity == null) {
                            pathMappingBhv.insert(pathMapping);
                        } else {
                            if (overwrite) {
                                pathMapping.setVersionNo(null);
                                Beans.copy(pathMapping, entity).excludesNull()
                                        .execute();
                                pathMapping = entity;
                                pathMappingBhv.update(pathMapping);
                            } else {
                                pathMappingBhv.insert(pathMapping);
                            }
                        }
                        idMap.put(PATH_MAPPING_KEY + ":" + id.toString(),
                                pathMapping.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: " + PATH_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // overlappingHost
            try {
                userTransaction.begin();

                List<OverlappingHost> overlappingHostList = (List<OverlappingHost>) dataSet
                        .get(OVERLAPPING_HOST_KEY + "List");
                if (overlappingHostList != null) {
                    for (OverlappingHost overlappingHost : overlappingHostList) {
                        Long id = overlappingHost.getId();

                        OverlappingHostCB cb = new OverlappingHostCB();
                        cb.query().setRegularName_Equal(
                                overlappingHost.getRegularName());
                        cb.query().setOverlappingName_Equal(
                                overlappingHost.getOverlappingName());
                        cb.query().setDeletedBy_IsNull();
                        OverlappingHost entity = overlappingHostBhv
                                .selectEntity(cb);
                        overlappingHost.setId(null);
                        if (entity == null) {
                            overlappingHostBhv.insert(overlappingHost);
                        } else {
                            if (overwrite) {
                                overlappingHost.setVersionNo(null);
                                Beans.copy(overlappingHost, entity)
                                        .excludesNull().execute();
                                overlappingHost = entity;
                                overlappingHostBhv.update(overlappingHost);
                            } else {
                                overlappingHostBhv.insert(overlappingHost);
                            }
                        }
                        idMap.put(OVERLAPPING_HOST_KEY + ":" + id.toString(),
                                overlappingHost.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: " + OVERLAPPING_HOST_KEY,
                        e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // webCrawlingConfig
            try {
                userTransaction.begin();

                List<WebCrawlingConfig> webCrawlingConfigList = (List<WebCrawlingConfig>) dataSet
                        .get(WEB_CRAWLING_CONFIG_KEY + "List");
                if (webCrawlingConfigList != null) {
                    for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
                        Long id = webCrawlingConfig.getId();

                        WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
                        cb.query().setName_Equal(webCrawlingConfig.getName());
                        cb.query().setDeletedBy_IsNull();
                        WebCrawlingConfig entity = webCrawlingConfigBhv
                                .selectEntity(cb);
                        webCrawlingConfig.setId(null);
                        if (entity == null) {
                            webCrawlingConfigBhv.insert(webCrawlingConfig);
                        } else {
                            if (overwrite) {
                                webCrawlingConfig.setVersionNo(null);
                                Beans.copy(webCrawlingConfig, entity)
                                        .excludesNull().execute();
                                webCrawlingConfig = entity;
                                webCrawlingConfigBhv.update(webCrawlingConfig);
                            } else {
                                webCrawlingConfigBhv.insert(webCrawlingConfig);
                            }
                        }
                        idMap.put(
                                WEB_CRAWLING_CONFIG_KEY + ":" + id.toString(),
                                webCrawlingConfig.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + WEB_CRAWLING_CONFIG_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // fileConfigToBrowserTypeMapping
            try {
                userTransaction.begin();

                List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList = (List<FileConfigToBrowserTypeMapping>) dataSet
                        .get(FILE_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + "List");
                if (fileConfigToBrowserTypeMappingList != null) {
                    for (FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping : fileConfigToBrowserTypeMappingList) {
                        Long id = fileConfigToBrowserTypeMapping.getId();

                        Long browserTypeId = idMap.get(BROWSER_TYPE_KEY
                                + ":"
                                + fileConfigToBrowserTypeMapping
                                        .getBrowserTypeId());
                        Long fileConfigId = idMap.get(FILE_CRAWLING_CONFIG_KEY
                                + ":"
                                + fileConfigToBrowserTypeMapping
                                        .getFileConfigId());
                        if (browserTypeId == null || fileConfigId == null) {
                            // skip
                            continue;
                        }

                        FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
                        cb.query().setBrowserTypeId_Equal(browserTypeId);
                        cb.query().setFileConfigId_Equal(fileConfigId);
                        FileConfigToBrowserTypeMapping entity = fileConfigToBrowserTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            fileConfigToBrowserTypeMapping = new FileConfigToBrowserTypeMapping();
                            fileConfigToBrowserTypeMapping
                                    .setBrowserTypeId(browserTypeId);
                            fileConfigToBrowserTypeMapping
                                    .setFileConfigId(fileConfigId);
                            fileConfigToBrowserTypeMappingBhv
                                    .insert(fileConfigToBrowserTypeMapping);
                        }
                        idMap.put(FILE_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + ":"
                                + id.toString(), fileConfigToBrowserTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + FILE_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // dataConfigToBrowserTypeMapping
            try {
                userTransaction.begin();

                List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList = (List<DataConfigToBrowserTypeMapping>) dataSet
                        .get(DATA_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + "List");
                if (dataConfigToBrowserTypeMappingList != null) {
                    for (DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping : dataConfigToBrowserTypeMappingList) {
                        Long id = dataConfigToBrowserTypeMapping.getId();

                        Long browserTypeId = idMap.get(BROWSER_TYPE_KEY
                                + ":"
                                + dataConfigToBrowserTypeMapping
                                        .getBrowserTypeId());
                        Long dataConfigId = idMap.get(DATA_CRAWLING_CONFIG_KEY
                                + ":"
                                + dataConfigToBrowserTypeMapping
                                        .getDataConfigId());
                        if (browserTypeId == null || dataConfigId == null) {
                            // skip
                            continue;
                        }

                        DataConfigToBrowserTypeMappingCB cb = new DataConfigToBrowserTypeMappingCB();
                        cb.query().setBrowserTypeId_Equal(browserTypeId);
                        cb.query().setDataConfigId_Equal(dataConfigId);
                        DataConfigToBrowserTypeMapping entity = dataConfigToBrowserTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            dataConfigToBrowserTypeMapping = new DataConfigToBrowserTypeMapping();
                            dataConfigToBrowserTypeMapping
                                    .setBrowserTypeId(browserTypeId);
                            dataConfigToBrowserTypeMapping
                                    .setDataConfigId(dataConfigId);
                            dataConfigToBrowserTypeMappingBhv
                                    .insert(dataConfigToBrowserTypeMapping);
                        }
                        idMap.put(DATA_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + ":"
                                + id.toString(), dataConfigToBrowserTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + DATA_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // webConfigToBrowserTypeMapping
            try {
                userTransaction.begin();

                List<WebConfigToBrowserTypeMapping> webConfigToBrowserTypeMappingList = (List<WebConfigToBrowserTypeMapping>) dataSet
                        .get(WEB_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + "List");
                if (webConfigToBrowserTypeMappingList != null) {
                    for (WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping : webConfigToBrowserTypeMappingList) {
                        Long id = webConfigToBrowserTypeMapping.getId();

                        Long browserTypeId = idMap.get(BROWSER_TYPE_KEY
                                + ":"
                                + webConfigToBrowserTypeMapping
                                        .getBrowserTypeId());
                        Long webConfigId = idMap.get(WEB_CRAWLING_CONFIG_KEY
                                + ":"
                                + webConfigToBrowserTypeMapping
                                        .getWebConfigId());
                        if (browserTypeId == null || webConfigId == null) {
                            // skip
                            continue;
                        }

                        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
                        cb.query().setBrowserTypeId_Equal(browserTypeId);
                        cb.query().setWebConfigId_Equal(webConfigId);
                        WebConfigToBrowserTypeMapping entity = webConfigToBrowserTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            webConfigToBrowserTypeMapping = new WebConfigToBrowserTypeMapping();
                            webConfigToBrowserTypeMapping
                                    .setBrowserTypeId(browserTypeId);
                            webConfigToBrowserTypeMapping
                                    .setWebConfigId(webConfigId);
                            webConfigToBrowserTypeMappingBhv
                                    .insert(webConfigToBrowserTypeMapping);
                        }
                        idMap.put(WEB_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY + ":"
                                + id.toString(), webConfigToBrowserTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + WEB_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // fileConfigToLabelTypeMapping
            try {
                userTransaction.begin();

                List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList = (List<FileConfigToLabelTypeMapping>) dataSet
                        .get(FILE_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + "List");
                if (fileConfigToLabelTypeMappingList != null) {
                    for (FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping : fileConfigToLabelTypeMappingList) {
                        Long id = fileConfigToLabelTypeMapping.getId();

                        Long labelTypeId = idMap
                                .get(LABEL_TYPE_KEY
                                        + ":"
                                        + fileConfigToLabelTypeMapping
                                                .getLabelTypeId());
                        Long fileConfigId = idMap.get(FILE_CRAWLING_CONFIG_KEY
                                + ":"
                                + fileConfigToLabelTypeMapping
                                        .getFileConfigId());
                        if (labelTypeId == null || fileConfigId == null) {
                            // skip
                            continue;
                        }

                        FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
                        cb.query().setLabelTypeId_Equal(labelTypeId);
                        cb.query().setFileConfigId_Equal(fileConfigId);
                        FileConfigToLabelTypeMapping entity = fileConfigToLabelTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            fileConfigToLabelTypeMapping = new FileConfigToLabelTypeMapping();
                            fileConfigToLabelTypeMapping
                                    .setLabelTypeId(labelTypeId);
                            fileConfigToLabelTypeMapping
                                    .setFileConfigId(fileConfigId);
                            fileConfigToLabelTypeMappingBhv
                                    .insert(fileConfigToLabelTypeMapping);
                        }
                        idMap.put(FILE_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + ":"
                                + id.toString(), fileConfigToLabelTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + FILE_CONFIG_TO_LABEL_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // dataConfigToLabelTypeMapping
            try {
                userTransaction.begin();

                List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList = (List<DataConfigToLabelTypeMapping>) dataSet
                        .get(DATA_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + "List");
                if (dataConfigToLabelTypeMappingList != null) {
                    for (DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping : dataConfigToLabelTypeMappingList) {
                        Long id = dataConfigToLabelTypeMapping.getId();

                        Long labelTypeId = idMap
                                .get(LABEL_TYPE_KEY
                                        + ":"
                                        + dataConfigToLabelTypeMapping
                                                .getLabelTypeId());
                        Long dataConfigId = idMap.get(DATA_CRAWLING_CONFIG_KEY
                                + ":"
                                + dataConfigToLabelTypeMapping
                                        .getDataConfigId());
                        if (labelTypeId == null || dataConfigId == null) {
                            // skip
                            continue;
                        }

                        DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
                        cb.query().setLabelTypeId_Equal(labelTypeId);
                        cb.query().setDataConfigId_Equal(dataConfigId);
                        DataConfigToLabelTypeMapping entity = dataConfigToLabelTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            dataConfigToLabelTypeMapping = new DataConfigToLabelTypeMapping();
                            dataConfigToLabelTypeMapping
                                    .setLabelTypeId(labelTypeId);
                            dataConfigToLabelTypeMapping
                                    .setDataConfigId(dataConfigId);
                            dataConfigToLabelTypeMappingBhv
                                    .insert(dataConfigToLabelTypeMapping);
                        }
                        idMap.put(DATA_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + ":"
                                + id.toString(), dataConfigToLabelTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + DATA_CONFIG_TO_LABEL_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // webConfigToLabelTypeMapping
            try {
                userTransaction.begin();

                List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList = (List<WebConfigToLabelTypeMapping>) dataSet
                        .get(WEB_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + "List");
                if (webConfigToLabelTypeMappingList != null) {
                    for (WebConfigToLabelTypeMapping webConfigToLabelTypeMapping : webConfigToLabelTypeMappingList) {
                        Long id = webConfigToLabelTypeMapping.getId();

                        Long labelTypeId = idMap.get(LABEL_TYPE_KEY + ":"
                                + webConfigToLabelTypeMapping.getLabelTypeId());
                        Long webConfigId = idMap.get(WEB_CRAWLING_CONFIG_KEY
                                + ":"
                                + webConfigToLabelTypeMapping.getWebConfigId());
                        if (labelTypeId == null || webConfigId == null) {
                            // skip
                            continue;
                        }

                        WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
                        cb.query().setLabelTypeId_Equal(labelTypeId);
                        cb.query().setWebConfigId_Equal(webConfigId);
                        WebConfigToLabelTypeMapping entity = webConfigToLabelTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
                            webConfigToLabelTypeMapping
                                    .setLabelTypeId(labelTypeId);
                            webConfigToLabelTypeMapping
                                    .setWebConfigId(webConfigId);
                            webConfigToLabelTypeMappingBhv
                                    .insert(webConfigToLabelTypeMapping);
                        }
                        idMap.put(WEB_CONFIG_TO_LABEL_TYPE_MAPPING_KEY + ":"
                                + id.toString(), webConfigToLabelTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + WEB_CONFIG_TO_LABEL_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // fileConfigToRoleTypeMapping
            try {
                userTransaction.begin();

                List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList = (List<FileConfigToRoleTypeMapping>) dataSet
                        .get(FILE_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + "List");
                if (fileConfigToRoleTypeMappingList != null) {
                    for (FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping : fileConfigToRoleTypeMappingList) {
                        Long id = fileConfigToRoleTypeMapping.getId();

                        Long roleTypeId = idMap.get(ROLE_TYPE_KEY + ":"
                                + fileConfigToRoleTypeMapping.getRoleTypeId());
                        Long fileConfigId = idMap
                                .get(FILE_CRAWLING_CONFIG_KEY
                                        + ":"
                                        + fileConfigToRoleTypeMapping
                                                .getFileConfigId());
                        if (roleTypeId == null || fileConfigId == null) {
                            // skip
                            continue;
                        }

                        FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
                        cb.query().setRoleTypeId_Equal(roleTypeId);
                        cb.query().setFileConfigId_Equal(fileConfigId);
                        FileConfigToRoleTypeMapping entity = fileConfigToRoleTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            fileConfigToRoleTypeMapping = new FileConfigToRoleTypeMapping();
                            fileConfigToRoleTypeMapping
                                    .setRoleTypeId(roleTypeId);
                            fileConfigToRoleTypeMapping
                                    .setFileConfigId(fileConfigId);
                            fileConfigToRoleTypeMappingBhv
                                    .insert(fileConfigToRoleTypeMapping);
                        }
                        idMap.put(FILE_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + ":"
                                + id.toString(), fileConfigToRoleTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + FILE_CONFIG_TO_ROLE_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // dataConfigToRoleTypeMapping
            try {
                userTransaction.begin();

                List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList = (List<DataConfigToRoleTypeMapping>) dataSet
                        .get(DATA_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + "List");
                if (dataConfigToRoleTypeMappingList != null) {
                    for (DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping : dataConfigToRoleTypeMappingList) {
                        Long id = dataConfigToRoleTypeMapping.getId();

                        Long roleTypeId = idMap.get(ROLE_TYPE_KEY + ":"
                                + dataConfigToRoleTypeMapping.getRoleTypeId());
                        Long dataConfigId = idMap
                                .get(DATA_CRAWLING_CONFIG_KEY
                                        + ":"
                                        + dataConfigToRoleTypeMapping
                                                .getDataConfigId());
                        if (roleTypeId == null || dataConfigId == null) {
                            // skip
                            continue;
                        }

                        DataConfigToRoleTypeMappingCB cb = new DataConfigToRoleTypeMappingCB();
                        cb.query().setRoleTypeId_Equal(roleTypeId);
                        cb.query().setDataConfigId_Equal(dataConfigId);
                        DataConfigToRoleTypeMapping entity = dataConfigToRoleTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            dataConfigToRoleTypeMapping = new DataConfigToRoleTypeMapping();
                            dataConfigToRoleTypeMapping
                                    .setRoleTypeId(roleTypeId);
                            dataConfigToRoleTypeMapping
                                    .setDataConfigId(dataConfigId);
                            dataConfigToRoleTypeMappingBhv
                                    .insert(dataConfigToRoleTypeMapping);
                        }
                        idMap.put(DATA_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + ":"
                                + id.toString(), dataConfigToRoleTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + DATA_CONFIG_TO_ROLE_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // webConfigToRoleTypeMapping
            try {
                userTransaction.begin();

                List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList = (List<WebConfigToRoleTypeMapping>) dataSet
                        .get(WEB_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + "List");
                if (webConfigToRoleTypeMappingList != null) {
                    for (WebConfigToRoleTypeMapping webConfigToRoleTypeMapping : webConfigToRoleTypeMappingList) {
                        Long id = webConfigToRoleTypeMapping.getId();

                        Long roleTypeId = idMap.get(ROLE_TYPE_KEY + ":"
                                + webConfigToRoleTypeMapping.getRoleTypeId());
                        Long webConfigId = idMap.get(WEB_CRAWLING_CONFIG_KEY
                                + ":"
                                + webConfigToRoleTypeMapping.getWebConfigId());
                        if (roleTypeId == null || webConfigId == null) {
                            // skip
                            continue;
                        }

                        WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
                        cb.query().setRoleTypeId_Equal(roleTypeId);
                        cb.query().setWebConfigId_Equal(webConfigId);
                        WebConfigToRoleTypeMapping entity = webConfigToRoleTypeMappingBhv
                                .selectEntity(cb);
                        if (entity == null) {
                            webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
                            webConfigToRoleTypeMapping
                                    .setRoleTypeId(roleTypeId);
                            webConfigToRoleTypeMapping
                                    .setWebConfigId(webConfigId);
                            webConfigToRoleTypeMappingBhv
                                    .insert(webConfigToRoleTypeMapping);
                        }
                        idMap.put(WEB_CONFIG_TO_ROLE_TYPE_MAPPING_KEY + ":"
                                + id.toString(), webConfigToRoleTypeMapping
                                .getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + WEB_CONFIG_TO_ROLE_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // webAuthentication
            try {
                userTransaction.begin();

                List<WebAuthentication> webAuthenticationList = (List<WebAuthentication>) dataSet
                        .get(WEB_AUTHENTICATION_KEY + "List");
                if (webAuthenticationList != null) {
                    for (WebAuthentication webAuthentication : webAuthenticationList) {
                        Long id = webAuthentication.getId();

                        Long webConfigId = idMap.get(WEB_CRAWLING_CONFIG_KEY
                                + ":"
                                + webAuthentication.getWebCrawlingConfigId());
                        if (webConfigId == null) {
                            // skip
                            continue;
                        }

                        WebAuthenticationCB cb = new WebAuthenticationCB();
                        cb.query().setWebCrawlingConfigId_Equal(webConfigId);
                        WebAuthentication entity = webAuthenticationBhv
                                .selectEntity(cb);
                        webAuthentication.setId(null);
                        webAuthentication.setWebCrawlingConfigId(webConfigId);
                        if (entity == null) {
                            webAuthenticationBhv.insert(webAuthentication);
                        } else {
                            if (overwrite) {
                                webAuthentication.setVersionNo(null);
                                Beans.copy(webAuthentication, entity)
                                        .excludesNull().execute();
                                webAuthentication = entity;
                                webAuthenticationBhv.update(webAuthentication);
                            } else {
                                webAuthenticationBhv.insert(webAuthentication);
                            }
                        }
                        idMap.put(WEB_AUTHENTICATION_KEY + ":" + id.toString(),
                                webAuthentication.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + WEB_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }
            // requestHeader
            try {
                userTransaction.begin();

                List<RequestHeader> requestHeaderList = (List<RequestHeader>) dataSet
                        .get(REQUEST_HEADER_KEY + "List");
                if (requestHeaderList != null) {
                    for (RequestHeader requestHeader : requestHeaderList) {
                        Long id = requestHeader.getId();

                        Long webConfigId = idMap.get(WEB_CRAWLING_CONFIG_KEY
                                + ":" + requestHeader.getWebCrawlingConfigId());
                        if (webConfigId == null) {
                            // skip
                            continue;
                        }

                        RequestHeaderCB cb = new RequestHeaderCB();
                        cb.query().setWebCrawlingConfigId_Equal(webConfigId);
                        RequestHeader entity = requestHeaderBhv
                                .selectEntity(cb);
                        requestHeader.setId(null);
                        requestHeader.setWebCrawlingConfigId(webConfigId);
                        if (entity == null) {
                            requestHeaderBhv.insert(requestHeader);
                        } else {
                            if (overwrite) {
                                requestHeader.setVersionNo(null);
                                Beans.copy(requestHeader, entity)
                                        .excludesNull().execute();
                                requestHeader = entity;
                                requestHeaderBhv.update(requestHeader);
                            } else {
                                requestHeaderBhv.insert(requestHeader);
                            }
                        }
                        idMap.put(REQUEST_HEADER_KEY + ":" + id.toString(),
                                requestHeader.getId());
                    }
                }
                userTransaction.commit();
            } catch (Exception e) {
                logger.warn("Failed to restore data: "
                        + WEB_CONFIG_TO_BROWSER_TYPE_MAPPING_KEY, e);
                try {
                    userTransaction.rollback();
                } catch (Exception e1) {
                    logger.warn("Failed to rollback data.", e1);
                }
            }

            // crawlerProperties
            try {
                Map<String, String> crawlerPropertyMap = (Map<String, String>) dataSet
                        .get(CRAWLER_PROPERTIES_KEY);
                String value;
                value = crawlerPropertyMap
                        .get(Constants.CRON_EXPRESSION_PROPERTY);
                if (StringUtil.isNotBlank(value)) {
                    crawlerProperties.setProperty(
                            Constants.CRON_EXPRESSION_PROPERTY, value);
                }
                value = crawlerPropertyMap.get(Constants.OPTIMIZE_PROPERTY);
                if (StringUtil.isNotBlank(value)) {
                    crawlerProperties.setProperty(Constants.OPTIMIZE_PROPERTY,
                            value);
                }
                value = crawlerPropertyMap.get(Constants.COMMIT_PROPERTY);
                if (StringUtil.isNotBlank(value)) {
                    crawlerProperties.setProperty(Constants.COMMIT_PROPERTY,
                            value);
                }
                value = crawlerPropertyMap
                        .get(Constants.SERVER_ROTATION_PROPERTY);
                if (StringUtil.isNotBlank(value)) {
                    crawlerProperties.setProperty(
                            Constants.SERVER_ROTATION_PROPERTY, value);
                }
                value = crawlerPropertyMap
                        .get(Constants.DAY_FOR_CLEANUP_PROPERTY);
                if (StringUtil.isNotBlank(value)) {
                    crawlerProperties.setProperty(
                            Constants.DAY_FOR_CLEANUP_PROPERTY, value);
                }
                value = crawlerPropertyMap
                        .get(Constants.COMMIT_PER_COUNT_PROPERTY);
                if (StringUtil.isNotBlank(value)) {
                    crawlerProperties.setProperty(
                            Constants.COMMIT_PER_COUNT_PROPERTY, value);
                }
                value = crawlerPropertyMap
                        .get(Constants.CRAWLING_THREAD_COUNT_PROPERTY);
                if (StringUtil.isNotBlank(value)) {
                    crawlerProperties.setProperty(
                            Constants.CRAWLING_THREAD_COUNT_PROPERTY, value);
                }
                value = crawlerPropertyMap
                        .get(Constants.MOBILE_TRANSCODER_PROPERTY);
                if (value != null) {
                    crawlerProperties.setProperty(
                            Constants.MOBILE_TRANSCODER_PROPERTY, value);
                }
                crawlerProperties.store();
            } catch (Exception e) {
                logger.warn(
                        "Failed to restore data: " + CRAWLER_PROPERTIES_KEY, e);
            }

        }
    }
}
