/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.util;

import java.util.Map;

import org.seasar.extension.unit.S2TestCase;

public class ParameterUtilTest extends S2TestCase {
    public void test_convertParameterMap() {
        String parameters;
        Map<String, String> parameterMap;

        parameters = "";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(0, parameterMap.size());

        parameters = "domain";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(1, parameterMap.size());
        assertEquals("", parameterMap.get("domain"));

        parameters = "domain=";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(1, parameterMap.size());
        assertEquals("", parameterMap.get("domain"));

        parameters = "domain=D";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(1, parameterMap.size());
        assertEquals("D", parameterMap.get("domain"));

        parameters = "domain=DOMAIN";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(1, parameterMap.size());
        assertEquals("DOMAIN", parameterMap.get("domain"));

        parameters = "\n";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(0, parameterMap.size());

        parameters = "domain\nworkstation";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(2, parameterMap.size());
        assertEquals("", parameterMap.get("domain"));
        assertEquals("", parameterMap.get("workstation"));

        parameters = "domain=\nworkstation=";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(2, parameterMap.size());
        assertEquals("", parameterMap.get("domain"));
        assertEquals("", parameterMap.get("workstation"));

        parameters = "domain=D\nworkstation=W";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(2, parameterMap.size());
        assertEquals("D", parameterMap.get("domain"));
        assertEquals("W", parameterMap.get("workstation"));

        parameters = "domain=DOMAIN\nworkstation=WORKSTATION";
        parameterMap = ParameterUtil.convertParameterMap(parameters);
        assertEquals(2, parameterMap.size());
        assertEquals("DOMAIN", parameterMap.get("domain"));
        assertEquals("WORKSTATION", parameterMap.get("workstation"));
    }
}
