/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.WebCrawlingConfigDbm;
import jp.sf.fess.db.cbean.FailureUrlCB;
import jp.sf.fess.db.cbean.RequestHeaderCB;
import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.exbhv.FailureUrlBhv;
import jp.sf.fess.db.exbhv.RequestHeaderBhv;
import jp.sf.fess.db.exbhv.WebAuthenticationBhv;
import jp.sf.fess.db.exbhv.WebConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebCrawlingConfigBhv;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.RequestHeader;
import jp.sf.fess.db.exentity.WebAuthentication;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of WEB_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, URLS, INCLUDED_URLS, EXCLUDED_URLS, INCLUDED_DOC_URLS, EXCLUDED_DOC_URLS, DEPTH, MAX_ACCESS_COUNT, USER_AGENT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FAILURE_URL, REQUEST_HEADER, WEB_AUTHENTICATION, WEB_CONFIG_TO_BROWSER_TYPE_MAPPING, WEB_CONFIG_TO_LABEL_TYPE_MAPPING, WEB_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     failureUrlList, requestHeaderList, webAuthenticationList, webConfigToBrowserTypeMappingList, webConfigToLabelTypeMappingList, webConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebCrawlingConfigBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "WEB_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return WebCrawlingConfigDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebCrawlingConfigDbm getMyDBMeta() {
        return WebCrawlingConfigDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public WebCrawlingConfig newMyEntity() {
        return new WebCrawlingConfig();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public WebCrawlingConfigCB newMyConditionBean() {
        return new WebCrawlingConfigCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * int count = webCrawlingConfigBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected count.
     */
    public int selectCount(WebCrawlingConfigCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(WebCrawlingConfigCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(WebCrawlingConfigCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * webCrawlingConfigBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;WebCrawlingConfig&gt;() {
     *     public void handle(WebCrawlingConfig entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @param entityRowHandler The handler of entity row of WebCrawlingConfig. (NotNull)
     */
    public void selectCursor(WebCrawlingConfigCB cb,
            EntityRowHandler<WebCrawlingConfig> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> void doSelectCursor(
            WebCrawlingConfigCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<WebCrawlingConfig>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * WebCrawlingConfig webCrawlingConfig = webCrawlingConfigBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (webCrawlingConfig != null) {
     *     ... = webCrawlingConfig.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebCrawlingConfig selectEntity(WebCrawlingConfigCB cb) {
        return doSelectEntity(cb, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ENTITY doSelectEntity(
            final WebCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, WebCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * WebCrawlingConfig webCrawlingConfig = webCrawlingConfigBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = webCrawlingConfig.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebCrawlingConfig selectEntityWithDeletedCheck(WebCrawlingConfigCB cb) {
        return doSelectEntityWithDeletedCheck(cb, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ENTITY doSelectEntityWithDeletedCheck(
            final WebCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, WebCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebCrawlingConfig selectByPKValue(Long id) {
        return doSelectByPKValue(id, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebCrawlingConfig selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private WebCrawlingConfigCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        WebCrawlingConfigCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;WebCrawlingConfig&gt; webCrawlingConfigList = webCrawlingConfigBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<WebCrawlingConfig> selectList(WebCrawlingConfigCB cb) {
        return doSelectList(cb, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> ListResultBean<ENTITY> doSelectList(
            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, WebCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;WebCrawlingConfig&gt; page = webCrawlingConfigBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (WebCrawlingConfig webCrawlingConfig : page) {
     *     ... = webCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<WebCrawlingConfig> selectPage(WebCrawlingConfigCB cb) {
        return doSelectPage(cb, WebCrawlingConfig.class);
    }

    protected <ENTITY extends WebCrawlingConfig> PagingResultBean<ENTITY> doSelectPage(
            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, WebCrawlingConfigCB>() {
                    public int callbackSelectCount(WebCrawlingConfigCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            WebCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(WebCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<WebCrawlingConfigCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends WebCrawlingConfigCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFailureUrlList(WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<FailureUrlCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadFailureUrlList(xnewLRLs(webCrawlingConfig), conditionBeanSetupper);
    }

    /**
     * Load referrer of failureUrlList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadFailureUrlList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;FailureUrlCB&gt;() {
     *     public void setup(FailureUrlCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getFailureUrlList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFailureUrlList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<FailureUrlCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadFailureUrlList(webCrawlingConfigList,
                new LoadReferrerOption<FailureUrlCB, FailureUrl>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFailureUrlList(WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<FailureUrlCB, FailureUrl> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadFailureUrlList(xnewLRLs(webCrawlingConfig), loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFailureUrlList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<FailureUrlCB, FailureUrl> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final FailureUrlBhv referrerBhv = xgetBSFLR().select(
                FailureUrlBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, FailureUrlCB, FailureUrl>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e, List<FailureUrl> ls) {
                        e.setFailureUrlList(ls);
                    }

                    public FailureUrlCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FailureUrlCB cb, List<Long> ls) {
                        cb.query().setWebConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(FailureUrlCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public void spFKCol(FailureUrlCB cb) {
                        cb.specify().columnWebConfigId();
                    }

                    public List<FailureUrl> selRfLs(FailureUrlCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FailureUrl e) {
                        return e.getWebConfigId();
                    }

                    public void setlcEt(FailureUrl re, WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadRequestHeaderList(WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<RequestHeaderCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadRequestHeaderList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of requestHeaderList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadRequestHeaderList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;RequestHeaderCB&gt;() {
     *     public void setup(RequestHeaderCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getRequestHeaderList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebCrawlingConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebCrawlingConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadRequestHeaderList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<RequestHeaderCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadRequestHeaderList(webCrawlingConfigList,
                new LoadReferrerOption<RequestHeaderCB, RequestHeader>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadRequestHeaderList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<RequestHeaderCB, RequestHeader> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadRequestHeaderList(xnewLRLs(webCrawlingConfig), loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadRequestHeaderList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<RequestHeaderCB, RequestHeader> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final RequestHeaderBhv referrerBhv = xgetBSFLR().select(
                RequestHeaderBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, RequestHeaderCB, RequestHeader>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<RequestHeader> ls) {
                        e.setRequestHeaderList(ls);
                    }

                    public RequestHeaderCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(RequestHeaderCB cb, List<Long> ls) {
                        cb.query().setWebCrawlingConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(RequestHeaderCB cb) {
                        cb.query().addOrderBy_WebCrawlingConfigId_Asc();
                    }

                    public void spFKCol(RequestHeaderCB cb) {
                        cb.specify().columnWebCrawlingConfigId();
                    }

                    public List<RequestHeader> selRfLs(RequestHeaderCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(RequestHeader e) {
                        return e.getWebCrawlingConfigId();
                    }

                    public void setlcEt(RequestHeader re, WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebAuthenticationList(WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebAuthenticationCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebAuthenticationList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webAuthenticationList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadWebAuthenticationList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;WebAuthenticationCB&gt;() {
     *     public void setup(WebAuthenticationCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getWebAuthenticationList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebCrawlingConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebCrawlingConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebAuthenticationList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebAuthenticationCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebAuthenticationList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebAuthenticationCB, WebAuthentication>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebAuthenticationList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebAuthenticationCB, WebAuthentication> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebAuthenticationList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebAuthenticationList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebAuthenticationCB, WebAuthentication> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebAuthenticationBhv referrerBhv = xgetBSFLR().select(
                WebAuthenticationBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebAuthenticationCB, WebAuthentication>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebAuthentication> ls) {
                        e.setWebAuthenticationList(ls);
                    }

                    public WebAuthenticationCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebAuthenticationCB cb, List<Long> ls) {
                        cb.query().setWebCrawlingConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebAuthenticationCB cb) {
                        cb.query().addOrderBy_WebCrawlingConfigId_Asc();
                    }

                    public void spFKCol(WebAuthenticationCB cb) {
                        cb.specify().columnWebCrawlingConfigId();
                    }

                    public List<WebAuthentication> selRfLs(
                            WebAuthenticationCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebAuthentication e) {
                        return e.getWebCrawlingConfigId();
                    }

                    public void setlcEt(WebAuthentication re,
                            WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadWebConfigToBrowserTypeMappingList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(WebConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getWebConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(WebConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToBrowserTypeMapping> ls) {
                        e.setWebConfigToBrowserTypeMappingList(ls);
                    }

                    public WebConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setWebConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public void spFKCol(WebConfigToBrowserTypeMappingCB cb) {
                        cb.specify().columnWebConfigId();
                    }

                    public List<WebConfigToBrowserTypeMapping> selRfLs(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToBrowserTypeMapping e) {
                        return e.getWebConfigId();
                    }

                    public void setlcEt(WebConfigToBrowserTypeMapping re,
                            WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToLabelTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadWebConfigToLabelTypeMappingList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *     public void setup(WebConfigToLabelTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getWebConfigToLabelTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToLabelTypeMapping> ls) {
                        e.setWebConfigToLabelTypeMappingList(ls);
                    }

                    public WebConfigToLabelTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToLabelTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setWebConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public void spFKCol(WebConfigToLabelTypeMappingCB cb) {
                        cb.specify().columnWebConfigId();
                    }

                    public List<WebConfigToLabelTypeMapping> selRfLs(
                            WebConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToLabelTypeMapping e) {
                        return e.getWebConfigId();
                    }

                    public void setlcEt(WebConfigToLabelTypeMapping re,
                            WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">loadWebConfigToRoleTypeMappingList</span>(webCrawlingConfigList, new ConditionBeanSetupper&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(WebConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (WebCrawlingConfig webCrawlingConfig : webCrawlingConfigList) {
     *     ... = webCrawlingConfig.<span style="color: #FD4747">getWebConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>() {
                    public Long getPKVal(WebCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToRoleTypeMapping> ls) {
                        e.setWebConfigToRoleTypeMappingList(ls);
                    }

                    public WebConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setWebConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public void spFKCol(WebConfigToRoleTypeMappingCB cb) {
                        cb.specify().columnWebConfigId();
                    }

                    public List<WebConfigToRoleTypeMapping> selRfLs(
                            WebConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToRoleTypeMapping e) {
                        return e.getWebConfigId();
                    }

                    public void setlcEt(WebConfigToRoleTypeMapping re,
                            WebCrawlingConfig le) {
                        re.setWebCrawlingConfig(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webCrawlingConfig.setFoo...(value);
     * webCrawlingConfig.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.set...;</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">insert</span>(webCrawlingConfig);
     * ... = webCrawlingConfig.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webCrawlingConfig The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(WebCrawlingConfig webCrawlingConfig) {
        doInsert(webCrawlingConfig, null);
    }

    protected void doInsert(WebCrawlingConfig webCrawlingConfig,
            InsertOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfig", webCrawlingConfig);
        prepareInsertOption(option);
        delegateInsert(webCrawlingConfig, option);
    }

    protected void prepareInsertOption(InsertOption<WebCrawlingConfigCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webCrawlingConfigBhv.<span style="color: #FD4747">update</span>(webCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final WebCrawlingConfig webCrawlingConfig) {
        doUpdate(webCrawlingConfig, null);
    }

    protected void doUpdate(WebCrawlingConfig webCrawlingConfig,
            final UpdateOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfig", webCrawlingConfig);
        prepareUpdateOption(option);
        helpUpdateInternally(webCrawlingConfig,
                new InternalUpdateCallback<WebCrawlingConfig>() {
                    public int callbackDelegateUpdate(WebCrawlingConfig entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(UpdateOption<WebCrawlingConfigCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected WebCrawlingConfigCB createCBForVaryingUpdate() {
        WebCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected WebCrawlingConfigCB createCBForSpecifiedUpdate() {
        WebCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">updateNonstrict</span>(webCrawlingConfig);
     * </pre>
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final WebCrawlingConfig webCrawlingConfig) {
        doUpdateNonstrict(webCrawlingConfig, null);
    }

    protected void doUpdateNonstrict(WebCrawlingConfig webCrawlingConfig,
            final UpdateOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfig", webCrawlingConfig);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(webCrawlingConfig,
                new InternalUpdateNonstrictCallback<WebCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param webCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(WebCrawlingConfig webCrawlingConfig) {
        doInesrtOrUpdate(webCrawlingConfig, null, null);
    }

    protected void doInesrtOrUpdate(WebCrawlingConfig webCrawlingConfig,
            final InsertOption<WebCrawlingConfigCB> insertOption,
            final UpdateOption<WebCrawlingConfigCB> updateOption) {
        helpInsertOrUpdateInternally(
                webCrawlingConfig,
                new InternalInsertOrUpdateCallback<WebCrawlingConfig, WebCrawlingConfigCB>() {
                    public void callbackInsert(WebCrawlingConfig entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(WebCrawlingConfig entity) {
                        doUpdate(entity, updateOption);
                    }

                    public WebCrawlingConfigCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(WebCrawlingConfigCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param webCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(WebCrawlingConfig webCrawlingConfig) {
        doInesrtOrUpdateNonstrict(webCrawlingConfig, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(
            WebCrawlingConfig webCrawlingConfig,
            final InsertOption<WebCrawlingConfigCB> insertOption,
            final UpdateOption<WebCrawlingConfigCB> updateOption) {
        helpInsertOrUpdateInternally(
                webCrawlingConfig,
                new InternalInsertOrUpdateNonstrictCallback<WebCrawlingConfig>() {
                    public void callbackInsert(WebCrawlingConfig entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdateNonstrict(WebCrawlingConfig entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webCrawlingConfigBhv.<span style="color: #FD4747">delete</span>(webCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(WebCrawlingConfig webCrawlingConfig) {
        doDelete(webCrawlingConfig, null);
    }

    protected void doDelete(WebCrawlingConfig webCrawlingConfig,
            final DeleteOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfig", webCrawlingConfig);
        prepareDeleteOption(option);
        helpDeleteInternally(webCrawlingConfig,
                new InternalDeleteCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDelete(WebCrawlingConfig entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(DeleteOption<WebCrawlingConfigCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrict</span>(webCrawlingConfig);
     * </pre>
     * @param webCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(WebCrawlingConfig webCrawlingConfig) {
        doDeleteNonstrict(webCrawlingConfig, null);
    }

    protected void doDeleteNonstrict(WebCrawlingConfig webCrawlingConfig,
            final DeleteOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfig", webCrawlingConfig);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(webCrawlingConfig,
                new InternalDeleteNonstrictCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(webCrawlingConfig);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param webCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(WebCrawlingConfig webCrawlingConfig) {
        doDeleteNonstrictIgnoreDeleted(webCrawlingConfig, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(
            WebCrawlingConfig webCrawlingConfig,
            final DeleteOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfig", webCrawlingConfig);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(
                webCrawlingConfig,
                new InternalDeleteNonstrictIgnoreDeletedCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<WebCrawlingConfig> webCrawlingConfigList) {
        return doBatchInsert(webCrawlingConfigList, null);
    }

    protected int[] doBatchInsert(
            List<WebCrawlingConfig> webCrawlingConfigList,
            InsertOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        prepareInsertOption(option);
        return delegateBatchInsert(webCrawlingConfigList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<WebCrawlingConfig> webCrawlingConfigList) {
        return doBatchUpdate(webCrawlingConfigList, null);
    }

    protected int[] doBatchUpdate(
            List<WebCrawlingConfig> webCrawlingConfigList,
            UpdateOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(webCrawlingConfigList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<WebCrawlingConfig> webCrawlingConfigList,
            SpecifyQuery<WebCrawlingConfigCB> updateColumnSpec) {
        return doBatchUpdate(webCrawlingConfigList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList) {
        return doBatchUpdateNonstrict(webCrawlingConfigList, null);
    }

    protected int[] doBatchUpdateNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList,
            UpdateOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(webCrawlingConfigList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList,
            SpecifyQuery<WebCrawlingConfigCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(webCrawlingConfigList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict((List) ls);
        } else {
            return varyingBatchUpdateNonstrict((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<WebCrawlingConfig> webCrawlingConfigList) {
        return doBatchDelete(webCrawlingConfigList, null);
    }

    protected int[] doBatchDelete(
            List<WebCrawlingConfig> webCrawlingConfigList,
            DeleteOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        prepareDeleteOption(option);
        return delegateBatchDelete(webCrawlingConfigList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList) {
        return doBatchDeleteNonstrict(webCrawlingConfigList, null);
    }

    protected int[] doBatchDeleteNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList,
            DeleteOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(webCrawlingConfigList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict((List) ls);
        } else {
            return varyingBatchDeleteNonstrict((List) ls, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * webCrawlingConfigBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;webCrawlingConfig, WebCrawlingConfigCB&gt;() {
     *     public ConditionBean setup(webCrawlingConfig entity, WebCrawlingConfigCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<WebCrawlingConfig, WebCrawlingConfigCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<WebCrawlingConfig, WebCrawlingConfigCB> setupper,
            InsertOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        WebCrawlingConfig entity = new WebCrawlingConfig();
        WebCrawlingConfigCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected WebCrawlingConfigCB createCBForQueryInsert() {
        WebCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setPK...(value);</span>
     * webCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * webCrawlingConfigBhv.<span style="color: #FD4747">queryUpdate</span>(webCrawlingConfig, cb);
     * </pre>
     * @param webCrawlingConfig The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(WebCrawlingConfig webCrawlingConfig,
            WebCrawlingConfigCB cb) {
        return doQueryUpdate(webCrawlingConfig, cb, null);
    }

    protected int doQueryUpdate(WebCrawlingConfig webCrawlingConfig,
            WebCrawlingConfigCB cb, UpdateOption<WebCrawlingConfigCB> option) {
        assertObjectNotNull("webCrawlingConfig", webCrawlingConfig);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(webCrawlingConfig, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (WebCrawlingConfigCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (WebCrawlingConfigCB) cb, (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * webCrawlingConfigBhv.<span style="color: #FD4747">queryDelete</span>(webCrawlingConfig, cb);
     * </pre>
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(WebCrawlingConfigCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(WebCrawlingConfigCB cb,
            DeleteOption<WebCrawlingConfigCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((WebCrawlingConfigCB) cb);
        } else {
            return varyingQueryDelete((WebCrawlingConfigCB) cb,
                    (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webCrawlingConfig.setFoo...(value);
     * webCrawlingConfig.setBar...(value);
     * InsertOption<WebCrawlingConfigCB> option = new InsertOption<WebCrawlingConfigCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * webCrawlingConfigBhv.<span style="color: #FD4747">varyingInsert</span>(webCrawlingConfig, option);
     * ... = webCrawlingConfig.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webCrawlingConfig The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(WebCrawlingConfig webCrawlingConfig,
            InsertOption<WebCrawlingConfigCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(webCrawlingConfig, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;WebCrawlingConfigCB&gt; option = new UpdateOption&lt;WebCrawlingConfigCB&gt;();
     *     option.self(new SpecifyQuery&lt;WebCrawlingConfigCB&gt;() {
     *         public void specify(WebCrawlingConfigCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     webCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdate</span>(webCrawlingConfig, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(WebCrawlingConfig webCrawlingConfig,
            UpdateOption<WebCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(webCrawlingConfig, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * webCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * UpdateOption&lt;WebCrawlingConfigCB&gt; option = new UpdateOption&lt;WebCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void specify(WebCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(webCrawlingConfig, option);
     * </pre>
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(WebCrawlingConfig webCrawlingConfig,
            UpdateOption<WebCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(webCrawlingConfig, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param webCrawlingConfig The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(WebCrawlingConfig webCrawlingConfig,
            InsertOption<WebCrawlingConfigCB> insertOption,
            UpdateOption<WebCrawlingConfigCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(webCrawlingConfig, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param webCrawlingConfig The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(
            WebCrawlingConfig webCrawlingConfig,
            InsertOption<WebCrawlingConfigCB> insertOption,
            UpdateOption<WebCrawlingConfigCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(webCrawlingConfig, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param webCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(WebCrawlingConfig webCrawlingConfig,
            DeleteOption<WebCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(webCrawlingConfig, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param webCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(WebCrawlingConfig webCrawlingConfig,
            DeleteOption<WebCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(webCrawlingConfig, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            List<WebCrawlingConfig> webCrawlingConfigList,
            InsertOption<WebCrawlingConfigCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(webCrawlingConfigList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            List<WebCrawlingConfig> webCrawlingConfigList,
            UpdateOption<WebCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(webCrawlingConfigList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList,
            UpdateOption<WebCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(webCrawlingConfigList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            List<WebCrawlingConfig> webCrawlingConfigList,
            DeleteOption<WebCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(webCrawlingConfigList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList,
            DeleteOption<WebCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(webCrawlingConfigList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<WebCrawlingConfig, WebCrawlingConfigCB> setupper,
            InsertOption<WebCrawlingConfigCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * WebCrawlingConfig webCrawlingConfig = new WebCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setPK...(value);</span>
     * webCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webCrawlingConfig.setVersionNo(value);</span>
     * WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;WebCrawlingConfigCB&gt; option = new UpdateOption&lt;WebCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void specify(WebCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webCrawlingConfigBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(webCrawlingConfig, cb, option);
     * </pre>
     * @param webCrawlingConfig The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(WebCrawlingConfig webCrawlingConfig,
            WebCrawlingConfigCB cb, UpdateOption<WebCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(webCrawlingConfig, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(WebCrawlingConfigCB cb,
            DeleteOption<WebCrawlingConfigCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<WebCrawlingConfigBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(WebCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(WebCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends WebCrawlingConfig> void delegateSelectCursor(
            WebCrawlingConfigCB cb, EntityRowHandler<ENTITY> erh,
            Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends WebCrawlingConfig> List<ENTITY> delegateSelectList(
            WebCrawlingConfigCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(WebCrawlingConfig e,
            InsertOption<WebCrawlingConfigCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(WebCrawlingConfig e,
            UpdateOption<WebCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(WebCrawlingConfig e,
            UpdateOption<WebCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(WebCrawlingConfig e,
            DeleteOption<WebCrawlingConfigCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(WebCrawlingConfig e,
            DeleteOption<WebCrawlingConfigCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<WebCrawlingConfig> ls,
            InsertOption<WebCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<WebCrawlingConfig> ls,
            UpdateOption<WebCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(List<WebCrawlingConfig> ls,
            UpdateOption<WebCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<WebCrawlingConfig> ls,
            DeleteOption<WebCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(List<WebCrawlingConfig> ls,
            DeleteOption<WebCrawlingConfigCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(WebCrawlingConfig e,
            WebCrawlingConfigCB inCB, ConditionBean resCB,
            InsertOption<WebCrawlingConfigCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(WebCrawlingConfig e,
            WebCrawlingConfigCB cb, UpdateOption<WebCrawlingConfigCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(WebCrawlingConfigCB cb,
            DeleteOption<WebCrawlingConfigCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected WebCrawlingConfig downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, WebCrawlingConfig.class);
    }

    protected WebCrawlingConfigCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                WebCrawlingConfigCB.class);
    }
}
