/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

import org.seasar.framework.util.StringUtil;
import org.seasar.struts.util.RequestUtil;

public class SystemHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    private AtomicBoolean crawlProcessStatus = new AtomicBoolean();

    public String getUsername() {
        String username = RequestUtil.getRequest().getRemoteUser();
        if (StringUtil.isBlank(username)) {
            username = "guest";
        }
        return username;
    }

    public Timestamp getCurrentTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public boolean readyCrawlProcess() {
        return crawlProcessStatus.compareAndSet(false, true);
    }

    public boolean isCrawlProcessRunning() {
        return crawlProcessStatus.get();
    }

    public void finishCrawlProcess() {
        crawlProcessStatus.set(false);
    }
}
