/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import jp.sf.fess.db.allcommon.CDef;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.ClickLog;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of SEARCH_LOG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, SEARCH_WORD, SEARCH_QUERY, SOLR_QUERY, REQUESTED_TIME, RESPONSE_TIME, HIT_COUNT, QUERY_OFFSET, QUERY_PAGE_SIZE, USER_AGENT, REFERER, CLIENT_IP, USER_SESSION_ID, ACCESS_TYPE
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     CLICK_LOG
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     clickLogList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsSearchLog implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK, ID, NotNull, BIGINT(19)} */
    protected Long _id;

    /** SEARCH_WORD: {IX, VARCHAR(1000)} */
    protected String _searchWord;

    /** SEARCH_QUERY: {VARCHAR(1000)} */
    protected String _searchQuery;

    /** SOLR_QUERY: {VARCHAR(1000)} */
    protected String _solrQuery;

    /** REQUESTED_TIME: {IX, NotNull, TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _requestedTime;

    /** RESPONSE_TIME: {IX, NotNull, INTEGER(10)} */
    protected Integer _responseTime;

    /** HIT_COUNT: {IX, NotNull, BIGINT(19)} */
    protected Long _hitCount;

    /** QUERY_OFFSET: {NotNull, INTEGER(10)} */
    protected Integer _queryOffset;

    /** QUERY_PAGE_SIZE: {NotNull, INTEGER(10)} */
    protected Integer _queryPageSize;

    /** USER_AGENT: {VARCHAR(255)} */
    protected String _userAgent;

    /** REFERER: {VARCHAR(1000)} */
    protected String _referer;

    /** CLIENT_IP: {VARCHAR(50)} */
    protected String _clientIp;

    /** USER_SESSION_ID: {IX+, VARCHAR(100)} */
    protected String _userSessionId;

    /** ACCESS_TYPE: {NotNull, VARCHAR(1), classification=AccessType} */
    protected String _accessType;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The modified properties for this entity. */
    protected final EntityModifiedProperties __modifiedProperties = newModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    /**
     * {@inheritDoc}
     */
    public String getTableDbName() {
        return "SEARCH_LOG";
    }

    /**
     * {@inheritDoc}
     */
    public String getTablePropertyName() { // according to Java Beans rule
        return "searchLog";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /**
     * {@inheritDoc}
     */
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                                         Primary Key
    //                                                                         ===========
    /**
     * {@inheritDoc}
     */
    public boolean hasPrimaryKeyValue() {
        if (getId() == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                             Classification Property
    //                                                             =======================
    /**
     * Set the value of accessType as the classification of AccessType. <br />
     * Access Type
     * @param cdef The instance of classification definition (as ENUM type). (NullAllowed)
     */
    public void setAccessTypeAsAccessType(CDef.AccessType cdef) {
        setAccessType(cdef != null ? cdef.code() : null);
    }

    /**
     * Get the value of accessType as the classification of AccessType. <br />
     * Access Type
     * <p>It's treated as case insensitive and if the code value is null, it returns null.</p>
     * @return The instance of classification definition (as ENUM type). (NullAllowed)
     */
    public CDef.AccessType getAccessTypeAsAccessType() {
        return CDef.AccessType.codeOf(getAccessType());
    }

    // ===================================================================================
    //                                                              Classification Setting
    //                                                              ======================
    /**
     * Set the value of accessType as Web. <br />
     * Web: Web
     */
    public void setAccessType_Web() {
        setAccessTypeAsAccessType(CDef.AccessType.Web);
    }

    /**
     * Same as setAccessType_Web. <br />
     * Web: Web
     */
    public void classifyAccessTypeWeb() {
        setAccessType_Web();
    }

    /**
     * Set the value of accessType as Mobile. <br />
     * Mobile: Mobile
     */
    public void setAccessType_Mobile() {
        setAccessTypeAsAccessType(CDef.AccessType.Mobile);
    }

    /**
     * Same as setAccessType_Mobile. <br />
     * Mobile: Mobile
     */
    public void classifyAccessTypeMobile() {
        setAccessType_Mobile();
    }

    /**
     * Set the value of accessType as Xml. <br />
     * Xml: Xml
     */
    public void setAccessType_Xml() {
        setAccessTypeAsAccessType(CDef.AccessType.Xml);
    }

    /**
     * Same as setAccessType_Xml. <br />
     * Xml: Xml
     */
    public void classifyAccessTypeXml() {
        setAccessType_Xml();
    }

    /**
     * Set the value of accessType as Json. <br />
     * Json: Json
     */
    public void setAccessType_Json() {
        setAccessTypeAsAccessType(CDef.AccessType.Json);
    }

    /**
     * Same as setAccessType_Json. <br />
     * Json: Json
     */
    public void classifyAccessTypeJson() {
        setAccessType_Json();
    }

    /**
     * Same as setAccessTypeAsAccessType(cdef). <br />
     * @param cdef The instance of classification definition (as ENUM type). (NullAllowed)
     */
    public void classifyAccessType(CDef.AccessType cdef) {
        setAccessTypeAsAccessType(cdef);
    }

    // ===================================================================================
    //                                                        Classification Determination
    //                                                        ============================
    /**
     * Is the value of accessType 'Web'? <br />
     * Web: Web
     * <p>It's treated as case insensitive and if the code value is null, it returns false.</p>
     * @return Determination.
     */
    public boolean isAccessTypeWeb() {
        CDef.AccessType cdef = getAccessTypeAsAccessType();
        return cdef != null ? cdef.equals(CDef.AccessType.Web) : false;
    }

    /**
     * Is the value of accessType 'Mobile'? <br />
     * Mobile: Mobile
     * <p>It's treated as case insensitive and if the code value is null, it returns false.</p>
     * @return Determination.
     */
    public boolean isAccessTypeMobile() {
        CDef.AccessType cdef = getAccessTypeAsAccessType();
        return cdef != null ? cdef.equals(CDef.AccessType.Mobile) : false;
    }

    /**
     * Is the value of accessType 'Xml'? <br />
     * Xml: Xml
     * <p>It's treated as case insensitive and if the code value is null, it returns false.</p>
     * @return Determination.
     */
    public boolean isAccessTypeXml() {
        CDef.AccessType cdef = getAccessTypeAsAccessType();
        return cdef != null ? cdef.equals(CDef.AccessType.Xml) : false;
    }

    /**
     * Is the value of accessType 'Json'? <br />
     * Json: Json
     * <p>It's treated as case insensitive and if the code value is null, it returns false.</p>
     * @return Determination.
     */
    public boolean isAccessTypeJson() {
        CDef.AccessType cdef = getAccessTypeAsAccessType();
        return cdef != null ? cdef.equals(CDef.AccessType.Json) : false;
    }

    // ===================================================================================
    //                                                           Classification Name/Alias
    //                                                           =========================
    /**
     * Get the value of the column 'accessType' as classification name.
     * @return The string of classification name. (NullAllowed)
     */
    public String getAccessTypeName() {
        CDef.AccessType cdef = getAccessTypeAsAccessType();
        return cdef != null ? cdef.name() : null;
    }

    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    /** CLICK_LOG as 'clickLogList'. */
    protected List<ClickLog> _clickLogList;

    /**
     * CLICK_LOG as 'clickLogList'.
     * @return The entity list of referrer property 'clickLogList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<ClickLog> getClickLogList() {
        if (_clickLogList == null) {
            _clickLogList = new ArrayList<ClickLog>();
        }
        return _clickLogList;
    }

    /**
     * CLICK_LOG as 'clickLogList'.
     * @param clickLogList The entity list of referrer property 'clickLogList'. (NullAllowed)
     */
    public void setClickLogList(List<ClickLog> clickLogList) {
        _clickLogList = clickLogList;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    /**
     * {@inheritDoc}
     */
    public Set<String> modifiedProperties() {
        return __modifiedProperties.getPropertyNames();
    }

    /**
     * {@inheritDoc}
     */
    public void clearModifiedInfo() {
        __modifiedProperties.clear();
    }

    /**
     * {@inheritDoc}
     */
    public boolean hasModification() {
        return !__modifiedProperties.isEmpty();
    }

    protected EntityModifiedProperties newModifiedProperties() {
        return new EntityModifiedProperties();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If primary-keys or columns of the other are same as this one, returns true.
     * @param other The other entity. (NullAllowed)
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsSearchLog)) {
            return false;
        }
        BsSearchLog otherEntity = (BsSearchLog) other;
        if (!xSV(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean xSV(Object value1, Object value2) { // isSameValue()
        return InternalUtil.isSameValue(value1, value2);
    }

    /**
     * Calculates the hash-code from primary-keys or columns.
     * @return The hash-code from primary-key or columns.
     */
    public int hashCode() {
        int result = 17;
        result = xCH(result, getTableDbName());
        result = xCH(result, getId());
        return result;
    }

    protected int xCH(int result, Object value) { // calculateHashcode()
        return InternalUtil.calculateHashcode(result, value);
    }

    /**
     * @return The display string of all columns and relation existences. (NotNull)
     */
    public String toString() {
        return buildDisplayString(InternalUtil.toClassTitle(this), true, true);
    }

    /**
     * @return The display string of basic informations with one-nested relation values. (NotNull)
     */
    public String toStringWithRelation() {
        StringBuilder sb = new StringBuilder();
        sb.append(toString());
        String l = "\n  ";
        if (_clickLogList != null) {
            for (Entity e : _clickLogList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "clickLogList"));
                }
            }
        }
        return sb.toString();
    }

    protected String xbRDS(Entity e, String name) { // buildRelationDisplayString()
        return e.buildDisplayString(name, true, true);
    }

    /**
     * @param name The name for display. (NullAllowed: If it's null, it does not have a name)
     * @param column Does it contains column values or not?
     * @param relation Does it contains relation existences or not?
     * @return The display string for this entity. (NotNull)
     */
    public String buildDisplayString(String name, boolean column,
            boolean relation) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name).append(column || relation ? ":" : "");
        }
        if (column) {
            sb.append(buildColumnString());
        }
        if (relation) {
            sb.append(buildRelationString());
        }
        sb.append("@").append(Integer.toHexString(hashCode()));
        return sb.toString();
    }

    protected String buildColumnString() {
        String c = ", ";
        StringBuilder sb = new StringBuilder();
        sb.append(c).append(getId());
        sb.append(c).append(getSearchWord());
        sb.append(c).append(getSearchQuery());
        sb.append(c).append(getSolrQuery());
        sb.append(c).append(getRequestedTime());
        sb.append(c).append(getResponseTime());
        sb.append(c).append(getHitCount());
        sb.append(c).append(getQueryOffset());
        sb.append(c).append(getQueryPageSize());
        sb.append(c).append(getUserAgent());
        sb.append(c).append(getReferer());
        sb.append(c).append(getClientIp());
        sb.append(c).append(getUserSessionId());
        sb.append(c).append(getAccessType());
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected String buildRelationString() {
        StringBuilder sb = new StringBuilder();
        String c = ",";
        if (_clickLogList != null && !_clickLogList.isEmpty()) {
            sb.append(c).append("clickLogList");
        }
        if (sb.length() > 0) {
            sb.delete(0, c.length()).insert(0, "(").append(")");
        }
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'ID'. (NullAllowed)
     */
    public Long getId() {
        return _id;
    }

    /**
     * [set] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @param id The value of the column 'ID'. (NullAllowed)
     */
    public void setId(Long id) {
        __modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * [get] SEARCH_WORD: {IX, VARCHAR(1000)} <br />
     * @return The value of the column 'SEARCH_WORD'. (NullAllowed)
     */
    public String getSearchWord() {
        return _searchWord;
    }

    /**
     * [set] SEARCH_WORD: {IX, VARCHAR(1000)} <br />
     * @param searchWord The value of the column 'SEARCH_WORD'. (NullAllowed)
     */
    public void setSearchWord(String searchWord) {
        __modifiedProperties.addPropertyName("searchWord");
        this._searchWord = searchWord;
    }

    /**
     * [get] SEARCH_QUERY: {VARCHAR(1000)} <br />
     * @return The value of the column 'SEARCH_QUERY'. (NullAllowed)
     */
    public String getSearchQuery() {
        return _searchQuery;
    }

    /**
     * [set] SEARCH_QUERY: {VARCHAR(1000)} <br />
     * @param searchQuery The value of the column 'SEARCH_QUERY'. (NullAllowed)
     */
    public void setSearchQuery(String searchQuery) {
        __modifiedProperties.addPropertyName("searchQuery");
        this._searchQuery = searchQuery;
    }

    /**
     * [get] SOLR_QUERY: {VARCHAR(1000)} <br />
     * @return The value of the column 'SOLR_QUERY'. (NullAllowed)
     */
    public String getSolrQuery() {
        return _solrQuery;
    }

    /**
     * [set] SOLR_QUERY: {VARCHAR(1000)} <br />
     * @param solrQuery The value of the column 'SOLR_QUERY'. (NullAllowed)
     */
    public void setSolrQuery(String solrQuery) {
        __modifiedProperties.addPropertyName("solrQuery");
        this._solrQuery = solrQuery;
    }

    /**
     * [get] REQUESTED_TIME: {IX, NotNull, TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'REQUESTED_TIME'. (NullAllowed)
     */
    public java.sql.Timestamp getRequestedTime() {
        return _requestedTime;
    }

    /**
     * [set] REQUESTED_TIME: {IX, NotNull, TIMESTAMP(23, 10)} <br />
     * @param requestedTime The value of the column 'REQUESTED_TIME'. (NullAllowed)
     */
    public void setRequestedTime(java.sql.Timestamp requestedTime) {
        __modifiedProperties.addPropertyName("requestedTime");
        this._requestedTime = requestedTime;
    }

    /**
     * [get] RESPONSE_TIME: {IX, NotNull, INTEGER(10)} <br />
     * @return The value of the column 'RESPONSE_TIME'. (NullAllowed)
     */
    public Integer getResponseTime() {
        return _responseTime;
    }

    /**
     * [set] RESPONSE_TIME: {IX, NotNull, INTEGER(10)} <br />
     * @param responseTime The value of the column 'RESPONSE_TIME'. (NullAllowed)
     */
    public void setResponseTime(Integer responseTime) {
        __modifiedProperties.addPropertyName("responseTime");
        this._responseTime = responseTime;
    }

    /**
     * [get] HIT_COUNT: {IX, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'HIT_COUNT'. (NullAllowed)
     */
    public Long getHitCount() {
        return _hitCount;
    }

    /**
     * [set] HIT_COUNT: {IX, NotNull, BIGINT(19)} <br />
     * @param hitCount The value of the column 'HIT_COUNT'. (NullAllowed)
     */
    public void setHitCount(Long hitCount) {
        __modifiedProperties.addPropertyName("hitCount");
        this._hitCount = hitCount;
    }

    /**
     * [get] QUERY_OFFSET: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'QUERY_OFFSET'. (NullAllowed)
     */
    public Integer getQueryOffset() {
        return _queryOffset;
    }

    /**
     * [set] QUERY_OFFSET: {NotNull, INTEGER(10)} <br />
     * @param queryOffset The value of the column 'QUERY_OFFSET'. (NullAllowed)
     */
    public void setQueryOffset(Integer queryOffset) {
        __modifiedProperties.addPropertyName("queryOffset");
        this._queryOffset = queryOffset;
    }

    /**
     * [get] QUERY_PAGE_SIZE: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'QUERY_PAGE_SIZE'. (NullAllowed)
     */
    public Integer getQueryPageSize() {
        return _queryPageSize;
    }

    /**
     * [set] QUERY_PAGE_SIZE: {NotNull, INTEGER(10)} <br />
     * @param queryPageSize The value of the column 'QUERY_PAGE_SIZE'. (NullAllowed)
     */
    public void setQueryPageSize(Integer queryPageSize) {
        __modifiedProperties.addPropertyName("queryPageSize");
        this._queryPageSize = queryPageSize;
    }

    /**
     * [get] USER_AGENT: {VARCHAR(255)} <br />
     * @return The value of the column 'USER_AGENT'. (NullAllowed)
     */
    public String getUserAgent() {
        return _userAgent;
    }

    /**
     * [set] USER_AGENT: {VARCHAR(255)} <br />
     * @param userAgent The value of the column 'USER_AGENT'. (NullAllowed)
     */
    public void setUserAgent(String userAgent) {
        __modifiedProperties.addPropertyName("userAgent");
        this._userAgent = userAgent;
    }

    /**
     * [get] REFERER: {VARCHAR(1000)} <br />
     * @return The value of the column 'REFERER'. (NullAllowed)
     */
    public String getReferer() {
        return _referer;
    }

    /**
     * [set] REFERER: {VARCHAR(1000)} <br />
     * @param referer The value of the column 'REFERER'. (NullAllowed)
     */
    public void setReferer(String referer) {
        __modifiedProperties.addPropertyName("referer");
        this._referer = referer;
    }

    /**
     * [get] CLIENT_IP: {VARCHAR(50)} <br />
     * @return The value of the column 'CLIENT_IP'. (NullAllowed)
     */
    public String getClientIp() {
        return _clientIp;
    }

    /**
     * [set] CLIENT_IP: {VARCHAR(50)} <br />
     * @param clientIp The value of the column 'CLIENT_IP'. (NullAllowed)
     */
    public void setClientIp(String clientIp) {
        __modifiedProperties.addPropertyName("clientIp");
        this._clientIp = clientIp;
    }

    /**
     * [get] USER_SESSION_ID: {IX+, VARCHAR(100)} <br />
     * @return The value of the column 'USER_SESSION_ID'. (NullAllowed)
     */
    public String getUserSessionId() {
        return _userSessionId;
    }

    /**
     * [set] USER_SESSION_ID: {IX+, VARCHAR(100)} <br />
     * @param userSessionId The value of the column 'USER_SESSION_ID'. (NullAllowed)
     */
    public void setUserSessionId(String userSessionId) {
        __modifiedProperties.addPropertyName("userSessionId");
        this._userSessionId = userSessionId;
    }

    /**
     * [get] ACCESS_TYPE: {NotNull, VARCHAR(1), classification=AccessType} <br />
     * @return The value of the column 'ACCESS_TYPE'. (NullAllowed)
     */
    public String getAccessType() {
        return _accessType;
    }

    /**
     * [set] ACCESS_TYPE: {NotNull, VARCHAR(1), classification=AccessType} <br />
     * @param accessType The value of the column 'ACCESS_TYPE'. (NullAllowed)
     */
    public void setAccessType(String accessType) {
        __modifiedProperties.addPropertyName("accessType");
        this._accessType = accessType;
    }
}
