package filebookmark.dialog;

import java.util.Map;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import filebookmark.Activator;
import filebookmark.Images;
import filebookmark.model.Bookmark;
import filebookmark.model.Category;
import filebookmark.util.ElementType;
import filebookmark.util.FileBookmarkUtil;

public class AddDialog extends Dialog {

	private boolean single = false;
	private Map<String, String> fileInfo;
	
	private Text txtName = null;

	private Tree tree = null;

	private final int CREATE_ID = 100;

	private Category rootCategory;

	private boolean url = false;
	
	public AddDialog(Shell parentShell) {
		super(parentShell);
	}

	protected Point getInitialSize() {
		return new Point(300, 300);
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("AddDialog.dialog_title")); //$NON-NLS-1$
	}

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		GridLayout layout = new GridLayout();
		layout.makeColumnsEqualWidth = false;
		composite.setLayout(layout);

		Label nameLabel = new Label(composite, SWT.NONE);
		nameLabel.setText(Messages.getString("AddDialog.dialog_name")); //$NON-NLS-1$
		txtName = new Text(composite, SWT.SINGLE | SWT.BORDER);
		txtName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		if(single){
			String name = fileInfo.keySet().iterator().next();
			txtName.setText(name);
		}
		txtName.setEnabled(single);
		
		Label folderLabel = new Label(composite, SWT.NONE);
		folderLabel.setText(Messages.getString("AddDialog.dialog_making")); //$NON-NLS-1$
		tree = new Tree(composite, SWT.BORDER | SWT.SINGLE);
		tree.setLayoutData(new GridData(GridData.FILL_BOTH));

		TreeItem parentItem = new TreeItem(tree, SWT.NONE);
		rootCategory = FileBookmarkUtil.readXml();
		parentItem.setText(rootCategory.getName());
		parentItem.setImage(Activator.getImage(Images.ICON_BOOK_CLOSE));
		parentItem.setData(rootCategory);

		// [gIԂɂ
		tree.setSelection(parentItem);
		setTreeItem(parentItem, rootCategory);
		return composite;
	}

	protected void createButtonsForButtonBar(Composite parent) {

		createButton(parent, CREATE_ID, Messages.getString("AddDialog.dialog_new_category"), false); //$NON-NLS-1$

		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	protected void buttonPressed(int buttonId) {
		// OKꂽAOƍ쐬擾ĕ
		if (buttonId == IDialogConstants.OK_ID) {
			createNewBookmark();
			setReturnCode(buttonId);
			close();

		//VJeS
		} else if (buttonId == CREATE_ID) {
			createNewCategory();
		}

		super.buttonPressed(buttonId);
	}

	//ubN}[N쐬AXMLɏ
	protected void createNewBookmark() {

		TreeItem selectItem = tree.getSelection()[0];
		Category category = (Category)selectItem.getData();

		for(String name : fileInfo.keySet()){
			String inputName = null;
			if(fileInfo.size() == 1){
				inputName = txtName.getText();
				//͂ȂftHgݒ
				if(inputName == null || "".equals(inputName)){ //$NON-NLS-1$
					inputName = name;
				}
			}else{
				inputName = name;
			}
			// 쐬於ƍ쐬̃pX
			String fileType = ""; //$NON-NLS-1$
			if(url){
				fileType ="URL"; //$NON-NLS-1$
			}
			Bookmark bookmark = new Bookmark(inputName, fileInfo.get(name), fileType);
			category.addChild(bookmark);
		}
		
		//XML
		FileBookmarkUtil.writeXml();
	}

	protected void createNewCategory() {
		InputDialog newDialog = new InputDialog(Display.getDefault()
				.getActiveShell(), Messages.getString("AddDialog.dialog_new_category"), Messages.getString("AddDialog.dialog_name"), "New Category", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				new IInputValidator() {

					public String isValid(String newText) {
						if (newText.length() == 0) {
							return Messages.getString("AddDialog.dialog_not_input_name"); //$NON-NLS-1$
						}else if(!FileBookmarkUtil.getRootCategory().exist(newText)){
							return Messages.getString("AddDialog.dialog_repetition_category"); //$NON-NLS-1$
						}
						return null;
					}

				}) {
			protected Point getInitialSize() {
				return new Point(270, 160);
			}
		};

		if (newDialog.open() == Window.OK) {
			
			//r[֒ǉ
			 TreeItem item = tree.getSelection()[0];
			 TreeItem newItem = new TreeItem(item, SWT.NONE);
			 newItem.setText(newDialog.getValue());
			 newItem.setImage(Activator.getImage(Images.ICON_BOOK_CLOSE));
			 
			//JeS
			Category category = new Category(newDialog.getValue());
			newItem.setData(category);
			//eJeSɒǉ
			Category selectCategory = (Category) item.getData();
			selectCategory.addChild(category);
			
			//ǉꂽJeSIԂɂ
			tree.setSelection(newItem);
		}
	}



	// Tree
	private void setTreeItem(TreeItem parentTree, Category category) {

		if(!category.hasChildren()){
			return;
		}
		
		for(Bookmark childCategory : category.getChildren()){
			
			if(childCategory.getType() == ElementType.CATEGORY){
				TreeItem childTree = new TreeItem(parentTree, SWT.NONE);
				childTree.setData(childCategory);
				childTree.setText(childCategory.getName());
				childTree.setImage(Activator.getImage(Images.ICON_BOOK_CLOSE));
				setTreeItem(childTree, (Category)childCategory);
			}
		}

	}

	public void setFileInfo(Map<String, String> fileInfo){
		this.fileInfo = fileInfo;
		single = (fileInfo.size() == 1);
	}

	public void setUrl(boolean url){
		this.url = url;
	}
}
