package filebookmark.view;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

import filebookmark.Activator;
import filebookmark.Images;
import filebookmark.actions.DelAction;
import filebookmark.actions.OpenAction;
import filebookmark.model.Bookmark;
import filebookmark.model.Category;
import filebookmark.util.ElementType;
import filebookmark.util.FileBookmarkUtil;
import filebookmark.util.XmlAccessor;

public class BookmarkView extends ViewPart {
	private TreeViewer viewer;
	private DrillDownAdapter drillDownAdapter;
	private ViewContentProvider provider;
	private OpenAction openAction;
	
	private MenuManager menuManager;
	private List dragList;
	
	/**
	 * The constructor.
	 */
	public BookmarkView() {
	}

	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		provider = new ViewContentProvider();
		viewer = new TreeViewer(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		drillDownAdapter = new DrillDownAdapter(viewer);
		viewer.setContentProvider(provider);
		viewer.setLabelProvider(new ViewLabelProvider());
		viewer.setInput(getViewSite());
		viewer.expandAll();
		openAction = new OpenAction();

		//Listenero^
		hookDoubleClickAction();
		hookDragAction();
		hookDropAction();
		hookMouseHoverAction();
		hookKeyPressAction();
		
		//|bvAbvݒ
		getSite().setSelectionProvider(viewer);		
		menuManager = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener(){

			public void menuAboutToShow(IMenuManager manager) {
				manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
				manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS + "-end")); //$NON-NLS-1$
			}
			
		});
	
		Menu menu = menuManager.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuManager,getSite().getSelectionProvider());
		
		//c[WJ
		viewer.expandAll();

	}

	/** L[vXANV */
	private void hookKeyPressAction() {
		viewer.getTree().addListener(SWT.KeyUp, new Listener(){
		
			public void handleEvent(Event event) {
				if(event.keyCode == SWT.DEL){
					DelAction delAction = new DelAction();
					delAction.selectionChanged(null, viewer.getSelection());
					delAction.run(null);
				}						
			}
			
		});
	}
	
	/** }EXEzo[ANV */
	private void hookMouseHoverAction() {
		//TreẽXiǉ
		viewer.getTree().addListener(SWT.MouseHover, new Listener(){

			//}EXI[o[Ńt@C̃pXtooltipŕ\
			public void handleEvent(Event event) {
				TreeItem item = viewer.getTree().getItem(new Point(event.x, event.y));
				if(item != null){
					Bookmark obj = (Bookmark)item.getData();
					if(obj.getType() == ElementType.CATEGORY){
						viewer.getTree().setToolTipText(""); //$NON-NLS-1$
					}else if(obj.getType() == ElementType.BOOKMARK){
						viewer.getTree().setToolTipText(obj.getPath());	
					}else{
						viewer.getTree().setToolTipText(""); //$NON-NLS-1$
					}
				}else{
					viewer.getTree().setToolTipText(""); //$NON-NLS-1$
				}
			}
		});
	}

	/** _uNbNANV */
	private void hookDoubleClickAction() {
		viewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {

				Bookmark obj = (Bookmark)((IStructuredSelection)event.getSelection()).getFirstElement();
				if(obj.getType() == ElementType.CATEGORY){
					if(viewer.getExpandedState((Category)obj)){
						viewer.collapseToLevel((Category)obj, 1);
					}else{
						viewer.expandToLevel((Category)obj, 1);
					}
				}else if(obj.getType() == ElementType.BOOKMARK){
					openAction.doubleClickRun(event.getSelection());
				}
			}
		});
	}

	/** hbOANV */
	private void hookDragAction() {
		Transfer[] transfers = new Transfer[] {BookmarkTransfer.getTransfer()};
		viewer.addDragSupport(DND.DROP_MOVE , transfers, new DragSourceListener(){
			
			public void dragFinished(DragSourceEvent event) {							
			}

			public void dragSetData(DragSourceEvent event) {
			}

			public void dragStart(DragSourceEvent event) {

				List selection = ((IStructuredSelection)viewer.getSelection()).toList();
				
				for(Object obj : selection){
					//[g͈ړłȂ
					if(((Bookmark)obj).getType() == ElementType.CATEGORY
							&& "Bookmark".equals(((Bookmark)obj).getName())){ //$NON-NLS-1$
						event.doit = false;
					}
					
					if(!(obj instanceof Bookmark)){
						event.doit = false;
					}
				}
				
				dragList = selection;
				event.data = dragList;
			}
			
		});
	}
	
	/** hbvANV */
	private void hookDropAction(){
		Transfer[] transfers = new Transfer[] { BookmarkTransfer.getTransfer(), LocalSelectionTransfer.getTransfer()};
		viewer.addDropSupport(DND.DROP_LINK | DND.DROP_MOVE, transfers, new DropTargetListener(){

			public void dragEnter(DropTargetEvent event) {
			}

			public void dragLeave(DropTargetEvent event) {
			}

			public void dragOperationChanged(DropTargetEvent event) {
			}

			public void dragOver(DropTargetEvent event) {
				event.detail = DND.DROP_NONE;
				
				if(event.item != null 
						&& event.item instanceof TreeItem){
				
					Bookmark dropObject = (Bookmark)event.item.getData();
					
					if(dragList != null){
						for(Object obj:dragList){
							Bookmark dragObject = (Bookmark)obj;
							//hbvłȂݒ肷
							if(dragObject.getType() == ElementType.CATEGORY){
								//hbOƃhbv̏ꍇ֎~
								if(dragObject.equals(dropObject)){
									event.detail = DND.DROP_NONE;
									break;
								//qvfւ̃hbv͋֎~
								}else if(!isDrop(dropObject, ((Category)dragObject).getChildrenList())){
									event.detail = DND.DROP_NONE;
									break;
								}else{
									event.detail = DND.DROP_MOVE;
								}
							//ubN}[N͍DɈړ
							}else{
								event.detail = DND.DROP_MOVE;
							}
						}
						
					//pbP[WGNXv[[̃hbOhbv
					}else if(dropObject.getType() == ElementType.CATEGORY){
						
						DropTarget droptarget = (DropTarget)event.getSource();
						Transfer[] transfer = droptarget.getTransfer();
						
						for(Transfer targetTransfer : transfer){
							if (targetTransfer instanceof org.eclipse.jface.util.LocalSelectionTransfer) {
								
								ISelection selection = ((org.eclipse.jface.util.LocalSelectionTransfer) targetTransfer).getSelection();
								List selectionList = ((IStructuredSelection)selection).toList();
								
								if(selectionList != null && selectionList.size() > 0){
									for(Object obj: selectionList){
										if(!(obj instanceof IFile
												|| obj instanceof ICompilationUnit)){
											event.detail = DND.DROP_NONE;
											break;
										}
										event.detail = DND.DROP_LINK;
									}
									
								}
							}
						}						
					}
				}
//				}else {
//					event.detail = DND.DROP_NONE;
//				}
			}
			
			//qvfւ̃ANZX`FbN
			public boolean isDrop(Bookmark dropObject, List<Bookmark> children){
				
				if(children.contains(dropObject)){
					return false;
				}
				
				for(Bookmark child : children){
					
					if(child.getType() == ElementType.CATEGORY
							&& ((Category)child).hasChildren()){
						if(!isDrop(dropObject, ((Category)child).getChildrenList())){
							return false;
						}
					}
				}
				
				return true;
			}
			
			//hbv
			public void drop(DropTargetEvent event) {
				if(event.item != null){

					if(event.item instanceof TreeItem){
						Bookmark dropObject = (Bookmark)event.item.getData();
						
						//hbv悪JeS
						if(dropObject.getType() == ElementType.CATEGORY && dragList != null){
							
							for(Object obj : dragList){
								Bookmark dragObject = (Bookmark)obj;
								//̐ẽJeS̃Xg̖ɒǉ
								List<Bookmark> parentList = dragObject.getParentCategory().getChildrenList();
								int delIndex = parentList.indexOf(dragObject);
								((Category)dropObject).addChild(parentList.remove(delIndex));
							}

						//hbv悪ubN}[N
						}else if(dropObject.getType() == ElementType.BOOKMARK && dragList != null){
							for(Object obj : dragList){
								Bookmark dragObject = (Bookmark)obj;
								//Ԃւ
								List<Bookmark> parentList = dragObject.getParentCategory().getChildrenList();
								int delIndex = parentList.indexOf(dragObject);
								List<Bookmark> list = dropObject.getParentCategory().getChildrenList();
								int index = list.indexOf(dropObject);
								list.add(index, parentList.remove(delIndex));
								dragObject.setParentCategory(dropObject.getParentCategory());						
							}
							
						//pbP[WGNXv[[̃hbOhbv
						}else if(dropObject.getType() == ElementType.CATEGORY && dragList == null){
							DropTarget droptarget = (DropTarget)event.getSource();
							Transfer[] transfer = droptarget.getTransfer();
							
							for(Transfer targetTransfer : transfer){
								if (targetTransfer instanceof org.eclipse.jface.util.LocalSelectionTransfer) {
									
									ISelection selection = ((org.eclipse.jface.util.LocalSelectionTransfer) targetTransfer).getSelection();
									List selectionList = ((IStructuredSelection)selection).toList();
									for(Object obj: selectionList){
										String name = null;
										String path = null;
										if(obj instanceof IFile){
											name = ((IFile)obj).getName();
											path = ((IFile)obj).getFullPath().toString();
										}else if(obj instanceof ICompilationUnit){
											name = ((ICompilationUnit)obj).getElementName();
											path = ((ICompilationUnit)obj).getPath().toString();
										}
										
										((Category)dropObject).addChild(new Bookmark(name, path));
										
									}
									
									break;
								}
							}
						}
						
						refresh();
						FileBookmarkUtil.writeXml();
						dragList = null;
					}
				}
			}


			public void dropAccept(DropTargetEvent event) {
			}
			
		});
	}
	
	/** tH[JXݒ */
	public void setFocus() {
		viewer.getControl().setFocus();
	}

	/** tbV */
	public void refresh() {
		provider.initialize();
		viewer.refresh();
	}

	class ViewContentProvider implements IStructuredContentProvider,
		ITreeContentProvider {
		private Category invisibleRoot;
		
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}
		
		public void dispose() {
		}
		
		public Object[] getElements(Object parent) {
			if (parent.equals(getViewSite())) {
				if (invisibleRoot == null)
					initialize();
				return getChildren(invisibleRoot);
			}
			return getChildren(parent);
		}
		
		public Object getParent(Object child) {
			if (child instanceof Bookmark) {
				return ((Bookmark) child).getParentCategory();
			}
			return null;
		}
		
		public Object[] getChildren(Object parent) {
			if (parent instanceof Category) {
				return ((Category) parent).getChildren();
			}
			return new Object[0];
		}
		
		public boolean hasChildren(Object parent) {
			if (parent instanceof Category)
				return ((Category) parent).hasChildren();
			return false;
		}
		
		public void initialize() {
			Category rootCategory = FileBookmarkUtil.getRootCategory();
		
			invisibleRoot = new Category("root"); //$NON-NLS-1$
			invisibleRoot.setName(""); //$NON-NLS-1$
			invisibleRoot.setPath(""); //$NON-NLS-1$
			invisibleRoot.addChild(rootCategory);
		}
		
	}

	//xvoC_
	class ViewLabelProvider extends LabelProvider {
	
		public String getText(Object obj) {
			return obj.toString();
		}
		
		public Image getImage(Object obj) {
			
			if(((Bookmark)obj).getType() == ElementType.CATEGORY){
				return Activator.getImage(Images.ICON_BOOK_CLOSE);
			}else if("URL".equals(((Bookmark)obj).getFileType())){ //$NON-NLS-1$
				return Activator.getImage(Images.ICON_BOOKMARK_URL);
			}
			
			return Activator.getImage(Images.ICON_BOOKMARK_FILE);

		}
	}
}
