/**
 *
 */
package fs.game.reversi.gl;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import fs.game.reversi.Global;
import fs.game.reversi.game.Stone;
import fs.game.reversi.gl.SquareObject.onSquareEvent;

/**
 * @author noguchi
 * 
 */
public class BoardObject extends GLBasicRenderer implements GLToucheableObject {

	// 角度
	private float angle = 0.0f;

	// サイズ
	private float size = 1.0f;

	// 移動スピード（増分）
	private float sizeSpeed = 0.01f;
	private float angleSpeed = 0.25f;

	private SquareObject[][] squares = new SquareObject[8][8];

	private SquareObject.onSquareEvent squareEvent = new onSquareEvent() {

		@Override
		public void onTouched(SquareObject square, int x, int y) {
			onSquareTouched(square, x, y);
		}
	};

	public BoardObject(Context context, int width, int height) {
		super(context, width, height);
	}

	public void initialize() {
		for (int i = 0; i < 8; i++) {
			for (int j = 0; j < 8; j++) {
				squares[i][j] = new SquareObject(context, width, height, i, j);
				squares[i][j].offset_X = this.offset_X;
				squares[i][j].offset_Y = this.offset_Y;
				squares[i][j].addEventHandler(squareEvent);
			}
		}
	}

	/**
	 * オセロ板の初期化
	 */
	public void initializeGame() {
		// 最初はすべて戻す
		for (int i = 0; i < 8; i++) {
			for (int j = 0; j < 8; j++) {
				if (squares[i][j].getPiece() != null) {
					squares[i][j].clearPiece();
				}
			}
		}

		for (int y = 0; y < 8; y++) {
			for (int x = 0; x < 8; x++) {
				Stone stone = Global.board.getStone(x, y);
				if (stone == Stone.Black) {
					squares[x][y].createPiece(Stone.Black);
				} else if (stone == Stone.White) {
					squares[x][y].createPiece(Stone.White);
				}
			}
		}
	}

	/* (非 Javadoc)
	 * @see fs.game.reversi.gl.GLBasicRenderer#render(javax.microedition.khronos.opengles.GL10)
	 */
	@Override
	public void render(GL10 gl) {
		super.render(gl);

		gl.glPushMatrix();
		{
			// 枠の全体の大きさを求める
			float w = 0.1f * 8;
			float h = 0.15f * 8;

			// 枠の幅を求める
			float boardWidth = squares[0][0].getSquareWidth() * 8 + 0.15f;
			float boardHeight = squares[0][0].getSquareHeight() * 8 + 0.175f;

			// 枠の外に正方形を描く
			GLUtility.drawRectangle(gl, -0.525f, -0.020f, boardWidth, boardHeight, 1.0f, 1.0f, 1.0f, 1.0f);

			for (int x = 0; x < 8; x++) {
				for (int y = 0; y < 8; y++) {
					squares[x][y].render(gl);
				}
			}

			// (2,2)に点を打つ
			GLUtility.drawCircle(gl, -0.94f, -0.44f, 8, 0.02f, 1.0f, 1.0f, 1.0f, 1.0f);

			// (6,2)に点を打つ
			GLUtility.drawCircle(gl, -0.11f, -0.44f, 8, 0.02f, 1.0f, 1.0f, 1.0f, 1.0f);

			// (2,6)に点を打つ
			GLUtility.drawCircle(gl, -0.94f, 0.4f, 8, 0.02f, 1.0f, 1.0f, 1.0f, 1.0f);

			// (6,6)に点を打つ
			GLUtility.drawCircle(gl, -0.11f, 0.4f, 8, 0.02f, 1.0f, 1.0f, 1.0f, 1.0f);
		}
		gl.glPopMatrix();

	}

	/* (非 Javadoc)
	 * @see fs.game.reversi.gl.GLBasicRenderer#onAfterSurfaceChanged(javax.microedition.khronos.opengles.GL10, int, int)
	 */
	@Override
	protected void onAfterSurfaceChanged(GL10 gl, int width, int height) {
		super.onAfterSurfaceChanged(gl, width, height);

		for (int i = 0; i < 8; i++) {
			for (int j = 0; j < 8; j++) {
				squares[i][j].onSurfaceChanged(gl, width, height);
				squares[i][j].onAfterSurfaceChanged(gl, width, height);
			}
		}
	}

	/**
	 * タッチされた際、イベントを処理する
	 * 
	 * @param x
	 * @param y
	 */
	public void onTouched(float x, float y) {
		for (int i = 0; i < 8; i++) {
			for (int j = 0; j < 8; j++) {
				squares[i][j].onTouched(x, y);
			}
		}
	}

	public void put(int x, int y, Stone stone) {
		if (squares[x][y].existsPiece()) {
			squares[x][y].getPiece().setFace(stone);
		} else {
			squares[x][y].createPiece(stone);
		}
	}

	private void onSquareTouched(SquareObject square, int x, int y) {
		if (square != null) {
			Global.localUser.move(x, y);
		}
	}

}
