/**
 *
 */
package fs.game.reversi.gl;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import android.opengl.GLSurfaceView;
import fs.game.reversi.Global;

/**
 * @author noguchi
 *
 */
public class GLBasicRenderer implements GLSurfaceView.Renderer {

	protected Context context = null;
	protected int width = 800;
	protected int height = 480;

	protected float left = Global.Left;
	protected float right = Global.Right;
	protected float bottom = Global.Bottom;
	protected float top = Global.Top;
	protected float zNear = Global.ZNear;
	protected float zFar = Global.ZFar;

	public float offset_X = 0.0f;
	public float offset_Y = 0.0f;


	public GLBasicRenderer(Context context, int width, int height) {
		this.context = context;
		this.width = width;
		this.height = height;
	}

	@Override
	public void onDrawFrame(GL10 gl) {
		onInitializeFrame(gl);

		render(gl);
	}

	/**
	 * フレーム更新の際にViewportや背景などを設定する
	 * 必要に応じてoverrideしてください
	 *
	 * @param gl
	 */
	protected void onInitializeFrame(GL10 gl){
		gl.glViewport(0, 0, width, height);
		gl.glMatrixMode(GL10.GL_PROJECTION);

		gl.glLoadIdentity();

		// 画面の大きさ
		gl.glOrthof(left, right, bottom, top, zNear, zFar);
		// 画面の中心を (0,0)とする
		gl.glMatrixMode(GL10.GL_MODELVIEW);
		gl.glLoadIdentity();

		// 黒で画面をクリア
		gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
		gl.glClear(GL10.GL_COLOR_BUFFER_BIT);
	}

	@Override
	public void onSurfaceChanged(GL10 gl, int width, int height) {
		Global.gl = gl;

		int w = 0;
		int h = 0;

		while( w < width && h < height ){
			w += 16;
			h += 9;
		}

		int w_offset = (width - w)/2;
		int h_offset = (height - h)/2;

		gl.glViewport(w_offset, h_offset, w, h);

		onAfterSurfaceChanged(gl, width, height);
	}

	/**
	 * Surfaceが変更された際に呼ばれるイベント
	 * 必要に応じてoverrideしてください
	 *
	 * @param gl
	 * @param width
	 * @param height
	 */
	protected void onAfterSurfaceChanged(GL10 gl, int width, int height){


	}

	@Override
	public void onSurfaceCreated(GL10 gl, EGLConfig config) {

	}

	public void onTouched(float x, float y) {

	}

	public void render(GL10 gl) {

	}


}
