/**
 *
 */
package fs.game.reversi.gl;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import fs.game.reversi.game.Stone;

/**
 * @author noguchi
 * 
 */
public class PieceObject extends GLBasicRenderer implements GLToucheableObject {

	private int pieceTexture = 0;
	private Stone face = null;
	private float objectX = 0.0f;
	private float objectY = 0.0f;
	private float objectWidth = 0.0f;
	private float objectHeight = 0.0f;

	public PieceObject(Context context, int width, int height, float objectX, float objectY, float objectWidth, float objectHeight) {
		super(context, width, height);
		this.objectX = objectX;
		this.objectY = objectY;
		this.objectWidth = objectWidth;
		this.objectHeight = objectHeight;
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see
	 * fs.game.reversi.gl.GLBasicRenderer#onAfterSurfaceChanged(javax.microedition
	 * .khronos.opengles.GL10, int, int)
	 */
	@Override
	protected void onAfterSurfaceChanged(GL10 gl, int width, int height) {

	}

	/*
	 * (非 Javadoc)
	 *
	 * @see fs.game.reversi.gl.GLBasicRenderer#onTouched(float, float)
	 */
	@Override
	public void onTouched(float x, float y) {

	}

	/*
	 * (非 Javadoc)
	 *
	 * @see
	 * fs.game.reversi.gl.GLBasicRenderer#render(javax.microedition.khronos.
	 * opengles.GL10)
	 */
	@Override
	public void render(GL10 gl) {
		if (this.pieceTexture == 0) {
			if (TextureManager.contains(fs.game.reversi.R.drawable.medal)) {
				// テクスチャのオブジェクトの取得
				this.pieceTexture = TextureManager.getTexture(fs.game.reversi.R.drawable.medal);
			} else {
				// テクスチャの生成を行う
				this.pieceTexture = GLUtility.loadTexture(gl, context.getResources(), fs.game.reversi.R.drawable.medal);
			}
		}

		if (face != null) {
			drawPiece(gl);
		}
	}

	public void drawPiece(GL10 gl) {
		gl.glEnable(GL10.GL_BLEND);
		{

			if (face == Stone.Black) {
				gl.glBlendFunc(GL10.GL_SRC_ALPHA, GL10.GL_ONE_MINUS_SRC_ALPHA);
				GLUtility.drawTexture(gl, objectX, objectY, objectWidth, objectHeight - 0.001f, pieceTexture, 0.3333f, 0.0f, 0.3333f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f);
			} else {
				gl.glBlendFunc(GL10.GL_SRC_ALPHA, GL10.GL_ONE);
				GLUtility.drawTexture(gl, objectX, objectY, objectWidth, objectHeight - 0.001f, pieceTexture, 0.6666f, 0.0f, 0.3333f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f);
			}
		}
		gl.glDisable(GL10.GL_BLEND);
	}

	/**
	 * @return face
	 */
	public Stone getFace() {
		return face;
	}

	/**
	 * @param face セットする face
	 */
	public void setFace(Stone stone) {
		this.face = stone;
	}

}
