﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Public Interface IAppBase
    Property AppBase As AppBase
End Interface

Public Interface IReadOnly
    Property [ReadOnly] As Boolean
End Interface

Public Class AppBase

    Public Enum RESULT As Integer

        OK = 0
        EXECUTE = 1

        ' Errors
        ARCHIVE_COMPRESS_ERR = -128
        ARCHIVE_COMPRESS_INVALID_PARAMS
        ARCHIVE_CRC_ERR
        ARCHIVE_EXTRACT_ERR
        ARCHIVE_EXTRACT_INVALID_PARAMS
        ARCHIVE_LIB_NOT_FOUND
        ARCHIVE_PASSWORD_MISSMATCH
        ARCHIVE_SCAN_PROCESS_ERR
        ARCHIVE_SCAN_PROCESS_EXITCODE_ERR
        ARCHIVE_USER_PROCESS_ERR
        CONFIG_SAVE_ERR
        CONFIG_LOAD_ERR
        CONFIG_FORMAT_ERR
        FILECOPY_ERR
        INVALID_FILE_EXT
        INVALID_BOOT_OPTION
        NO_OBJECT
        NO_FILE
        NO_DIRECTORY
        PRESET_CMD_BLANK
        PRESET_CMD_PARSE_ERR
        PRESET_CMD_NOT_EXIST
        USER_CANCEL

    End Enum

    Private Shared ReadOnly ResultsBuf As New Collections.Generic.Dictionary(Of RESULT, String) From
    {
        {RESULT.OK, "エラーはありません"},
        {RESULT.EXECUTE, "処理すべきファイルでした"},
        {RESULT.USER_CANCEL, "ユーザーによってキャンセルされました"},
        {RESULT.NO_OBJECT, "オブジェクトがありません"},
        {RESULT.NO_FILE, "ファイルが見つかりません"},
        {RESULT.NO_DIRECTORY, "ディレクトリが見つかりません"},
        {RESULT.INVALID_FILE_EXT, "非対応のファイル形式です"},
        {RESULT.INVALID_BOOT_OPTION, "起動オプションが不正です"},
        {RESULT.FILECOPY_ERR, "ファイルのコピーに失敗しました"},
        {RESULT.CONFIG_SAVE_ERR, "設定ファイルの保存に失敗しました"},
        {RESULT.CONFIG_LOAD_ERR, "設定ファイルの読込に失敗しました"},
        {RESULT.CONFIG_FORMAT_ERR, "設定ファイルの形式が不正です"},
        {RESULT.PRESET_CMD_BLANK, "コマンドを記述して下さい"},
        {RESULT.PRESET_CMD_PARSE_ERR, "コマンドを解析できません"},
        {RESULT.PRESET_CMD_NOT_EXIST, "実行ファイルが見つかりません"},
        {RESULT.ARCHIVE_PASSWORD_MISSMATCH, "パスワード保護された書庫です"},
        {RESULT.ARCHIVE_CRC_ERR, "アーカイブファイルのCRCエラーです"},
        {RESULT.ARCHIVE_LIB_NOT_FOUND, "アーカイブ実行ファイルが見つかりません"},
        {RESULT.ARCHIVE_COMPRESS_ERR, "書庫ファイルの圧縮に失敗しました"},
        {RESULT.ARCHIVE_COMPRESS_INVALID_PARAMS, "書庫ファイルの圧縮パラメータが不正です"},
        {RESULT.ARCHIVE_EXTRACT_ERR, "書庫ファイルの展開に失敗しました"},
        {RESULT.ARCHIVE_EXTRACT_INVALID_PARAMS, "書庫ファイルの展開パラメータが不正です"},
        {RESULT.ARCHIVE_SCAN_PROCESS_ERR, "書庫ファイルのサンプリング処理に失敗しました"},
        {RESULT.ARCHIVE_SCAN_PROCESS_EXITCODE_ERR, "書庫ファイルのサンプリング処理中にプロセスからエラーが報告されました"},
        {RESULT.ARCHIVE_USER_PROCESS_ERR, "書庫ファイルのユーザープロセス処理に失敗しました"}
    }
    Public Shared Function ResultMessage(ByVal enErr As RESULT) As String
        If ResultsBuf.ContainsKey(enErr) Then Return ResultsBuf(enErr)
        Return String.Empty
    End Function

    Public Enum LOGMODE As Integer
        MIN = -1
        DEF = 0
        MAX = 1
    End Enum

    Public Enum ENUM_OVERWRITEMODE As Integer
        PD_OW_KEEP_EXISTED
        PD_OW_OVERWRITE
    End Enum

    Public Enum ENUM_ARCHIVETYPE As Integer
        ZIP
        RAR
    End Enum

    Public Enum ENUM_MIRRORDELMODE As Integer
        FIRSTONLY
        ALL
    End Enum

    Public Enum PDTASK As Integer

        BIT_NONE = 0
        BIT_ERR_FILENOTEXISTS ' file is not exists
        BIT_ERR_DIRNOTEXISTS ' dir is not exists
        BIT_ERR_INVALID_CMD ' command parse error
        BIT_ERR_SCANCMD ' pre command error
        BIT_ERR_SCANCMD_INVALIDEXIT ' pre command invalid exit
        BIT_FILTERED
        BIT_HIDDEN_FILE
        BIT_HIDDEN_DIR
        BIT_HASDELETE ' file has delete target
        BIT_DELETE ' file is delete target
        BIT_USERCMD ' execute usercommand
        BIT_USERCANCEL
        BIT_USERCHECKED

        NONE = 0
        ERR_FILENOTEXISTS = 2 ^ BIT_ERR_FILENOTEXISTS
        ERR_DIRNOTEXISTS = 2 ^ BIT_ERR_DIRNOTEXISTS
        ERR_INVALID_CMD = 2 ^ BIT_ERR_INVALID_CMD
        ERR_SCANCMD = 2 ^ BIT_ERR_SCANCMD
        ERR_SCANCMD_INVALIDEXIT = 2 ^ BIT_ERR_SCANCMD_INVALIDEXIT
        FILTERED = 2 ^ BIT_FILTERED
        HIDDEN_FILE = 2 ^ BIT_HIDDEN_FILE
        HIDDEN_DIR = 2 ^ BIT_HIDDEN_DIR
        HASDELETE = 2 ^ BIT_HASDELETE
        DELETE = 2 ^ BIT_DELETE
        USERCMD = 2 ^ BIT_USERCMD
        USERCANCEL = 2 ^ BIT_USERCANCEL
        USERCHECKED = 2 ^ BIT_USERCHECKED

    End Enum

    Private Shared ReadOnly hashTaskFlagMsg As New Collections.Generic.Dictionary(Of PDTASK, String) From
    {
        {PDTASK.ERR_FILENOTEXISTS, "ファイルが見つかりません"},
        {PDTASK.ERR_DIRNOTEXISTS, "ディレクトリが見つかりません"},
        {PDTASK.ERR_INVALID_CMD, "スキャンコマンドの解析エラー、または置換できないキーワード"},
        {PDTASK.ERR_SCANCMD, "スキャンコマンドの実行エラー"},
        {PDTASK.ERR_SCANCMD_INVALIDEXIT, "スキャンコマンドの異常終了"},
        {PDTASK.FILTERED, "フィルター対象ファイル"},
        {PDTASK.HASDELETE, "削除対象ファイルリストを持っています"},
        {PDTASK.DELETE, "削除対象ファイル"},
        {PDTASK.USERCMD, "ユーザーコマンドを行う予定"},
        {PDTASK.USERCANCEL, "ユーザーキャンセルを受け付けました"}
    }
    Public Shared Function GetTaskFlagMsg(ByVal e As PDTASK) As String
        Return hashTaskFlagMsg(e)
    End Function

    ' construct /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Public Sub New(Optional ByVal Path As Logic.FileSystem.Path = Nothing)
        Config.ImportFromXml(Path)
    End Sub

    ' public properties //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Public ReadOnly Property ArchiveTaskConfig() As AppBase.ArchiveTaskOptionConfig
        Get
            Return Config.ExportableGroup.ArchiveTaskConfig
        End Get
    End Property

    Public ReadOnly Property ArchiveTaskPresets() As AppBase.ArchiveTaskPreset.Collection
        Get
            Return Config.ExportableGroup.ArchiveTaskPresets
        End Get
    End Property

    Public ReadOnly Config As New Configuration

    Public ReadOnly Property DefaultCompressSetting As AppBase.ArchiveOptionConfigCollection
        Get
            Return Config.ExportableGroup.DefaultCompressSetting
        End Get
    End Property

    Public ReadOnly Echoing As New EchoingObject

    Public ReadOnly Property EntryTaskPresets As AppBase.EntryTaskPreset.Collection
        Get
            Return Config.ExportableGroup.EntryTaskPresets
        End Get
    End Property

    ' Location of some.exe/dll which has written AppBase
    Public Shared ReadOnly ExecutingLocation As New Logic.LocalLocation(Reflection.Assembly.GetExecutingAssembly)

    ' Exception Log
    Public Shared ReadOnly ExceptionLog As New Logic.ExceptionLog(Logic.FileSystem.JoinPathElements(ExecutingLocation.UserAppDataPath.ToString, "exception.txt"), 20000)

    Public ReadOnly Property ImagingConfig() As AppBase.ImagingOptionConfig
        Get
            Return Config.ExportableGroup.ImagingOption
        End Get
    End Property

    Public ReadOnly MainTask As New Archive.Threading.MainTask(Me)

    ' private implements /////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Private SubTask As New Logic.Threading.TaskQueueingThread

End Class

