﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase
    Partial Public Class Archive
        Partial Public Class Threading

            Public Class EnumEntryTask
                Implements IAppBase
                Implements Logic.Threading.TaskQueueingThread.ITask
                Public Sub New()
                End Sub
                Public Sub New(ByVal AppBase As AppBase, ByVal Path As String)
                    Me.AppBase = AppBase
                    Me.Path = Path
                End Sub
                Public Property AppBase As AppBase Implements IAppBase.AppBase
                Public Path As String
                Public GetEntries() As EntryInfo
                Public ExitCode As RESULT
                Public Sub Task(ByVal SenderIsStopRequested As Logic.Threading.SignalHandler) Implements Logic.Threading.TaskQueueingThread.ITask.Task

                    If AppBase Is Nothing Then Return

                    AppBase.Echoing.TaskStartEcho("Enum Entries")
                    AppBase.Echoing.Log.Echo("Enum Entries " & Path, AppendLogArgs.LogType.Status)

                    If IO.File.Exists(Path) = False Then
                        AppBase.Echoing.TaskExitedEcho("File Not Found " & Path)
                        Return
                    End If

                    Dim ext_cfg As ArchiveOptionConfig = AppBase.Config.ExportableGroup.DefaultCompressSetting(Path)
                    If ext_cfg Is Nothing Then
                        AppBase.Echoing.TaskExitedEcho("Not Supported FileType " & Path)
                        Return
                    End If

                    Dim p As ArchiveProcess = ext_cfg.CreateProcess(AppBase, SenderIsStopRequested)
                    ExitCode = p.GetEntryList(GetEntries, Path)
                    If ExitCode <> RESULT.OK Then
                        AppBase.Echoing.TaskExitedEcho("GetEntryList() Failed " & ResultMessage(ExitCode))
                        Return
                    End If

                    If GetEntries IsNot Nothing AndAlso 0 < GetEntries.Length Then Array.Sort(GetEntries, New EntryInfo.EntryPathComparer)

                    AppBase.Echoing.ArchiveItemSelected.Echo(Path, ExitCode, GetEntries)
                    AppBase.Echoing.TaskCompletedEcho()

                    Dim LoadTask As New CoverLoadTask
                    LoadTask.AppBase = AppBase
                    LoadTask.Path = Path
                    LoadTask.Entries = GetEntries
                    AppBase.SubTask.Enqueue(LoadTask)

                End Sub

            End Class

        End Class ' AppBase.Archive.Threading

    End Class ' AppBase.Archive

End Class ' AppBase

