﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    <Serializable()> _
    Public Class ArchiveTaskPreset
        Implements Logic.INamed

        <Serializable()> _
        Public Class Collection
            Inherits Logic.SerializableCollections.UniqueNamedList(Of ArchiveTaskPreset)
        End Class

        Public Sub New()
            MyClass.New(Nothing)
        End Sub

        Public Sub New(ByRef NewName As String, Optional ByVal DefaultCompressSetting As ArchiveOptionConfigCollection = Nothing)
            Name = NewName
            ArchiveExtentionList = Nothing
            ScanCmd = ""
            IsExtract = True
            UserCmd = ""
            IsCompress = True
            CompressSetting = Nothing
            If Not DefaultCompressSetting Is Nothing Then CompressSetting = New ArchiveOptionConfigCollection(DefaultCompressSetting)
            RenamePolicy = "%Name%"
            IsFilteredDelete = False
        End Sub

        Public Property Name As String Implements Logic.INamed.Name

        Private m_ArchiveExtentionList As Logic.FileSystem.Extention.Collection
        Public Property ArchiveExtentionList As Logic.FileSystem.Extention.Collection
            Get
                Return m_ArchiveExtentionList
            End Get
            Set(ByVal value As Logic.FileSystem.Extention.Collection)
                If value Is Nothing Then
                    value = New Logic.FileSystem.Extention.Collection
                    For Each ext As Logic.FileSystem.Extention In AppBase.ArchiveOptionConfigCollection.ExtentionNames
                        value.Add(ext)
                    Next
                End If
                m_ArchiveExtentionList = value
            End Set
        End Property

        Public ScanCmd As String
        Public IsExtract As Boolean
        Public IsCompress As Boolean
        Public UserCmd As String
        Public CompressSetting As ArchiveOptionConfigCollection
        Public RenamePolicy As String
        Public IsFilteredDelete As Boolean

    End Class

End Class