﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Public Class Configuration
        Inherits Logic.SerializableCollections.ProtectedSerializable(Of ApplicationConfigurations)

        Public Class ApplicationConfigurations

            Private m_EntryListColumnInf As New Logic.DataGridViewUtility.ColumnDisplayInf.Collection
            Public Property EntryListColumnInf As Logic.DataGridViewUtility.ColumnDisplayInf.Collection
                Get
                    Return m_EntryListColumnInf
                End Get
                Set(ByVal value As Logic.DataGridViewUtility.ColumnDisplayInf.Collection)
                    If value Is Nothing Then value = New Logic.DataGridViewUtility.ColumnDisplayInf.Collection
                    m_EntryListColumnInf = value
                End Set
            End Property

            Private m_ExportableGroup As New Exportable
            Public Property ExportableGroup As Exportable
                Get
                    Return m_ExportableGroup
                End Get
                Set(ByVal value As Exportable)
                    If value Is Nothing Then value = New Exportable
                    m_ExportableGroup = value
                End Set
            End Property

            Private m_FileListColumnInf As New Logic.DataGridViewUtility.ColumnDisplayInf.Collection
            Public Property FileListColumnInf As Logic.DataGridViewUtility.ColumnDisplayInf.Collection
                Get
                    Return m_FileListColumnInf
                End Get
                Set(ByVal value As Logic.DataGridViewUtility.ColumnDisplayInf.Collection)
                    If value Is Nothing Then value = New Logic.DataGridViewUtility.ColumnDisplayInf.Collection
                    m_FileListColumnInf = value
                End Set
            End Property

            Private m_Locations As New Locations.OptionConfiguration
            Public Property Locations As Locations.OptionConfiguration
                Get
                    Return m_Locations
                End Get
                Set(value As Locations.OptionConfiguration)
                    If value Is Nothing Then value = New Locations.OptionConfiguration
                    m_Locations = value
                End Set
            End Property

            Private m_LogFilter As New AppBase.AppendLogArgs.LogTypeDictionary(Of Nullable(Of Boolean))
            Public Property LogFilter As AppBase.AppendLogArgs.LogTypeDictionary(Of Nullable(Of Boolean))
                Get
                    Return m_LogFilter
                End Get
                Set(ByVal value As AppBase.AppendLogArgs.LogTypeDictionary(Of Nullable(Of Boolean)))
                    If value Is Nothing Then value = New AppBase.AppendLogArgs.LogTypeDictionary(Of Nullable(Of Boolean))
                    m_LogFilter = value
                End Set
            End Property

            Private m_LogListColumnInf As New Logic.DataGridViewUtility.ColumnDisplayInf.Collection
            Public Property LogListColumnInf As Logic.DataGridViewUtility.ColumnDisplayInf.Collection
                Get
                    Return m_LogListColumnInf
                End Get
                Set(ByVal value As Logic.DataGridViewUtility.ColumnDisplayInf.Collection)
                    If value Is Nothing Then value = New Logic.DataGridViewUtility.ColumnDisplayInf.Collection
                    m_LogListColumnInf = value
                End Set
            End Property

            Public OpenCmdAsImage As String
            Public OpenCmdAsSound As String

            Private m_Path As Logic.FileSystem.Path = String.Empty
            Public ReadOnly Property Path As Logic.FileSystem.Path
                Get
                    Return m_Path
                End Get
            End Property

            Private m_WindowSize As New WindowSizeConfig.Collection
            Public Property WindowSize As WindowSizeConfig.Collection
                Get
                    Return m_WindowSize
                End Get
                Set(ByVal value As WindowSizeConfig.Collection)
                    If value Is Nothing Then value = New WindowSizeConfig.Collection
                    m_WindowSize = value
                End Set
            End Property

        End Class

        Public Sub New()
            Payload = New ApplicationConfigurations
        End Sub

        ' public properties ///////////////////////////////////////////////////////////////////////////////////////////////////

        Public ReadOnly Property EntryListColumnInf As Logic.DataGridViewUtility.ColumnDisplayInf.Collection
            Get
                Return Payload.EntryListColumnInf
            End Get
        End Property

        Public ReadOnly Property ExportableGroup As Exportable
            Get
                Return Payload.ExportableGroup
            End Get
        End Property

        Public ReadOnly Property FileListColumnInf As Logic.DataGridViewUtility.ColumnDisplayInf.Collection
            Get
                Return Payload.FileListColumnInf
            End Get
        End Property

        Public ReadOnly Property Locations As Locations.OptionConfiguration
            Get
                Return Payload.Locations
            End Get
        End Property

        Public ReadOnly Property LogFilter As AppBase.AppendLogArgs.LogTypeDictionary(Of Nullable(Of Boolean))
            Get
                Return Payload.LogFilter
            End Get
        End Property

        Public ReadOnly Property LogListColumnInf As Logic.DataGridViewUtility.ColumnDisplayInf.Collection
            Get
                Return Payload.LogListColumnInf
            End Get
        End Property

        Public Property OpenCmdAsImage As String
            Get
                Return Payload.OpenCmdAsImage
            End Get
            Set(ByVal value As String)
                Payload.OpenCmdAsImage = value
            End Set
        End Property

        Public Property OpenCmdAsSound As String
            Get
                Return Payload.OpenCmdAsSound
            End Get
            Set(ByVal value As String)
                Payload.OpenCmdAsSound = value
            End Set
        End Property

        Private m_Path As Logic.FileSystem.Path = AppBase.Locations.ConfigurationPath
        Public ReadOnly Property Path As Logic.FileSystem.Path
            Get
                Return m_Path.ToString
            End Get
        End Property

        Public ReadOnly Property WindowSize As WindowSizeConfig.Collection
            Get
                Return Payload.WindowSize
            End Get
        End Property

        ' public methods ///////////////////////////////////////////////////////////////////////////////////////////////////////

        Public Shadows Function ImportFromXml(Optional ByVal Path As Logic.FileSystem.Path = Nothing) As Boolean

            If Path Is Nothing OrElse Path.IsNullOrWhiteSpace Then Path = m_Path

            Payload = Nothing
            ImportFromXml = False

            If Path.FileExists Then
                Try
                    MyBase.ImportFromXml(Path)
                    If m_Path IsNot Path Then m_Path = Path.ToString
                    ImportFromXml = True
                Catch ex As SerializeException
#If DEBUG Then
                    Throw
#End If
                Catch
                End Try
            End If

            If Payload Is Nothing Then
                Payload = New ApplicationConfigurations
                m_Path = AppBase.Locations.ConfigurationPath
            End If

        End Function

        Public Shadows Function ExportToXml(Optional ByVal Path As Logic.FileSystem.Path = Nothing) As Boolean

            If Path Is Nothing OrElse Path.IsNullOrWhiteSpace Then Path = m_Path

            ExportToXml = False
            If Path.IsNullOrWhiteSpace = False Then
                Try
                    MyBase.ExportToXml(Path)
                    ExportToXml = True
                Catch ex As SerializeException
#If DEBUG Then
                    Throw
#End If
                Catch
                End Try
            End If

            If ExportToXml = False Then MsgBox("設定ファイルの保存に失敗しました。")

        End Function

    End Class

End Class
