﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Public Class TreeView
    Implements IAppBase

    Public Sub New()
        InitializeComponent()
        MenuStrip.Renderer = New AppDlg.ToolStripCustomRenderer
        Dim sz As Size = MinimumSize
        For Each Item As Windows.Forms.ToolStripItem In MenuStrip.Items
            sz.Width += Item.Width
        Next
        MinimumSize = sz
    End Sub

    ' Properties /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Public ReadOnly Property AppDlg As AppDlg
        Get
            AppDlg = TryCast(ParentForm, AppDlg)
        End Get
    End Property

    Private m_AppBase As AppBase
    Public Property AppBase As AppBase Implements IAppBase.AppBase
        Get
            Return m_AppBase
        End Get
        Set(ByVal value As AppBase)
            If AppBase IsNot Nothing Then
                AppBase.Echoing.Log.Remove(AddressOf AppendLog)
                AppBase.Echoing.Progress.Remove(AddressOf OnProgress)
            End If
            m_AppBase = value
            If value Is Nothing Then Return
            AppBase.Echoing.Log.Add(AddressOf AppendLog)
            AppBase.Echoing.Progress.Add(AddressOf OnProgress)
        End Set
    End Property

    ' Private Implements ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Private Sub TreeView_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        AppBase = Nothing
    End Sub

    Private Sub AppendLog(ByVal e As AppBase.AppendLogArgs)
        If e.t = AppBase.AppendLogArgs.LogType.ProgressOutline Then
            If InvokeRequired Then
                Invoke(New AppBase.AppendLogArgs.Echoes.Handler(AddressOf AppendLog), {e})
            Else
                ProgOutline.Text = e.Log
            End If
        End If
    End Sub

    Private Sub OnProgress(ByVal e As AppBase.ProgressArgs)
        If InvokeRequired Then
            Invoke(New AppBase.ProgressArgs.Echoes.Handler(AddressOf OnProgress), {e})
        Else
            If 0 < e.nMax And Prog.Maximum <> e.nMax Then Prog.Maximum = e.nMax
            Prog.Value = e.nValue
        End If
    End Sub

    Private Sub FileImport_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FileImport.Click
        AppDlg.FileImport()
    End Sub

    Private Sub FileExport_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FileExport.Click
        AppDlg.FileExport()
    End Sub

End Class
