﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic

    Public Class Echoes(Of TArgs)
        Public Delegate Sub Handler(ByVal e As TArgs)

        Public Sub Clear()
            SyncLock Payload
                Payload.Clear()
            End SyncLock
        End Sub

        Public Function Contains(ByVal d As Handler) As Boolean
            SyncLock Payload
                Contains = Contains(GetInvocationList(d))
            End SyncLock
        End Function

        Public Function Add(ByVal d As Handler) As Boolean
            Add = False
            SyncLock Payload
                Dim list As System.Collections.Generic.List(Of Handler) = GetInvocationList(d)
                If 0 < list.Count And Contains(list) = False Then
                    Payload.AddRange(list)
                    Add = True
                End If
            End SyncLock
        End Function

        Public Sub Remove(ByVal d As Handler)
            SyncLock Payload
                For Each item As Handler In GetInvocationList(d)
                    If Payload.Contains(item) Then Payload.Remove(item)
                Next
            End SyncLock
        End Sub

        Public Sub Echo(ByVal e As TArgs)
            SyncLock Payload
                For Each d As Handler In Payload
                    d(e)
                Next
            End SyncLock
        End Sub

        Private Payload As New System.Collections.Generic.List(Of Handler)

        Private Function Contains(ByVal list As System.Collections.Generic.IEnumerable(Of Handler)) As Boolean
            Contains = False
            If list Is Nothing Then Exit Function
            For Each item As Handler In list
                If Payload.Contains(item) Then
                    Contains = True
                    Exit For
                End If
            Next
        End Function

        Private Shared Function GetInvocationList(ByVal d As Handler) As System.Collections.Generic.List(Of Handler)

            Dim ret As New System.Collections.Generic.List(Of Handler)
            GetInvocationList = ret
            If d Is Nothing Then Exit Function

            Dim list As System.Delegate() = d.GetInvocationList
            For Each item As System.Delegate In list
                Dim try_result As Handler = TryCast(item, Handler)
                If try_result IsNot Nothing AndAlso ret.Contains(try_result) = False Then ret.Add(try_result)
            Next

        End Function

    End Class

End Class