﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class SerializableCollections

        <Serializable()> _
        Public Class UniqueNamedList(Of T As {INamed, Class})
            Inherits ProtectedSerializable(Of SerializableCollections.List(Of T))
            Implements System.Xml.Serialization.IXmlSerializable
            Implements System.Collections.IEnumerable

            Public ReadOnly Property Count As Integer
                Get
                    If Not Payload Is Nothing Then Return Payload.Count
                    Return -1
                End Get
            End Property

            Public Function IndexOf(ByRef name As String) As Integer
                If 0 < Count Then
                    For idx As Integer = 0 To Count - 1
                        If Payload(idx).Name = name Then Return idx
                    Next
                End If
                Return -1
            End Function

            Default Public ReadOnly Property Item(ByVal idx As Integer) As T
                Get
                    If 0 <= idx And idx < Count Then Return Payload(idx)
                    Return Nothing
                End Get
            End Property

            Default Public ReadOnly Property Item(ByVal name As String) As T
                Get
                    If 0 < Count Then
                        For Each ret As T In Payload
                            If ret.Name = name Then Return ret
                        Next
                    End If
                    Return Nothing
                End Get
            End Property

            Public Function Add(ByRef src As T) As Boolean
                If Payload Is Nothing Then Payload = New List(Of T)
                If Not src Is Nothing AndAlso IndexOf(src.Name) < 0 Then
                    Payload.Add(src)
                    Return True
                End If
                Return False
            End Function

            Public Sub Clear()
                If Payload IsNot Nothing Then Payload.Clear()
            End Sub

            Public Function Insert(ByRef src As T, Optional ByVal idx As Long = -1) As Boolean
                If Payload Is Nothing Then Payload = New List(Of T)
                If src Is Nothing OrElse 0 <= IndexOf(src.Name) Then Return False
                If 0 <= idx And idx < Count Then
                    Payload.Insert(idx, src)
                Else
                    Payload.Add(src)
                End If
                Return True
            End Function

            Public Function Remove(ByVal idx As Integer) As Boolean
                If 0 <= idx And idx < Count Then
                    Payload.RemoveAt(idx)
                    Return True
                End If
                Return False
            End Function

            Public Function Remove(ByRef name As String) As Boolean
                Dim objTarget As T = Item(name)
                If Not objTarget Is Nothing Then
                    Payload.Remove(objTarget)
                    Return True
                End If
                Return False
            End Function

            Public Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
                If Payload Is Nothing Then Return Nothing
                Return Payload.GetEnumerator
            End Function
        End Class

    End Class
End Class

