﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic

    Public Class [String]

        Public Shared Function Repeat(ByVal src As String, ByVal ct As Integer) As String
            If ct = 0 Then Return String.Empty
            If src Is Nothing Or ct < 0 Then Return Nothing
            Dim sb As New System.Text.StringBuilder(src.Length * ct)
            For joined As Integer = 0 To ct - 1
                sb.Append(src)
            Next
            Return sb.ToString
        End Function

        Public Class IndentBuilder
            Public Sub New(Optional ByVal IndentUnit As String = vbTab)
                Me.IndentUnit = IndentUnit
            End Sub
            Private m_IndentUnit As String = String.Empty
            Public Property IndentUnit As String
                Get
                    Return m_IndentUnit
                End Get
                Set(ByVal value As String)
                    If value Is Nothing Then value = String.Empty
                    m_IndentUnit = value
                End Set
            End Property
            Public Sub Append(ByVal str As String, Optional ByVal IndentDepth As Integer = 0)
                If str Is Nothing Then Return
                Dim Indent As String = Logic.String.Repeat(IndentUnit, System.Math.Max(0, IndentDepth))
                StringBuilder.Append(Indent & str.Replace(vbCrLf, vbCrLf & Indent))
            End Sub
            Public Sub AppendLine(ByVal str As String, Optional ByVal IndentDepth As Integer = 0)
                Append(str, IndentDepth)
                StringBuilder.AppendLine()
            End Sub
            Public Overrides Function ToString() As String
                Return StringBuilder.ToString()
            End Function
            Private StringBuilder As New System.Text.StringBuilder
        End Class

        Public Shared Function FromException(ByVal ex As Exception, Optional ByVal IndentUnit As String = vbTab, Optional ByVal IndentDepth As Integer = 0) As System.String
            Dim ret As New IndentBuilder(IndentUnit)
            RecursiveExceptionPrint(ret, ex, System.Math.Max(0, IndentDepth))
            Return ret.ToString
        End Function

        Private Shared Sub RecursiveExceptionPrintElement(ByVal src As IndentBuilder, ByVal Name As String, ByVal Value As String, ByVal IndentDepth As Integer)
            If Value Is Nothing Then Value = "Nothing"
            src.AppendLine(String.Format("{0}:{1}{2}", Name, IIf(Value.Contains(vbCrLf), vbCrLf, String.Empty), Value), IndentDepth)
        End Sub
        Private Shared Sub RecursiveExceptionPrint(ByVal src As IndentBuilder, ByVal ex As Exception, ByVal IndentDepth As Integer)
            If src Is Nothing OrElse ex Is Nothing Then Return
            Dim t As System.Type = ex.GetType
            RecursiveExceptionPrintElement(src, "TypeName", t.Name, IndentDepth)
            RecursiveExceptionPrintElement(src, "TypeFullName", t.FullName, IndentDepth)
            RecursiveExceptionPrintElement(src, "Message", ex.Message, IndentDepth)
            If ex.InnerException Is Nothing Then
                src.AppendLine("InnerException:Nothing", IndentDepth)
            Else
                src.AppendLine("InnerException:", IndentDepth)
                RecursiveExceptionPrint(src, ex.InnerException, IndentDepth + 1)
            End If
            RecursiveExceptionPrintElement(src, "Source", ex.Source, IndentDepth)
            RecursiveExceptionPrintElement(src, "StackTrace", ex.StackTrace, IndentDepth)
        End Sub

    End Class

End Class
