goog.provide('FlappAction');
goog.require('FlappIBit');

goog.scope(function() {

/**
 * @constructor
 */
FlappAction = function() {
    this.actionRecord = null;
};

FlappAction.exec = function(tag, movieClip, rootMovieClip) {
    console.debug("FlappAction.exec");
    var actionsBit = new FlappIBit();
    actionsBit.input(tag.actions);
    var code = 0;
    var stack = [];
    while (code = actionsBit.ui8()) {
        console.debug("FlappAction code:0x"+code.toString(16));
        if (code < 0x80) { // No Operand
            if (code < 0x1d) { // 0x1d(SetVariables)
                if (code < 0x0a) { // 0x0a(Add)
                    switch (code) {
                    case 0x06: // Play
                        movieClip.play();
                        break;
                    case 0x07: // Stop
                        movieClip.stop();
                        break;
                    default:
                        console.debug("FlappActiom: not implemented yet. code=0x%02x", code);
                        break;
                    }
                } else { // 0x0a(Add)<=code
                    switch (code) {
                    case 0x0a: // Add
                        var a = stack.pop();
                        var b = stack.pop();
                        a = (typeof a === 'number')?a:0;
                        b = (typeof b === 'number')?b:0;
                        stack.push(a + b);
                        break;
                    case 0x0b: // Subtract
                        var a = stack.pop();
                        var b = stack.pop();
                        a = (typeof a === 'number')?a:0;
                        b = (typeof b === 'number')?b:0;
                        stack.push(b - a);
                        break;
                    case 0x0c: // Multiply
                        var a = stack.pop();
                        var b = stack.pop();
                        a = (typeof a === 'number')?a:0;
                        b = (typeof b === 'number')?b:0;
                        stack.push(a * b);
                        break;
                    case 0x0c: // Devide
                        var a = stack.pop();
                        var b = stack.pop();
                        a = (typeof a === 'number')?a:0;
                        b = (typeof b === 'number')?b:0;
                        if (a === 0) {
                            stack.push('#ERROR#'); // SWF4
                            // Note: For SWF5, Infinity or -Infinity is pushed.
                        } else {
                            stack.push(b / a);
                        }
                        break;
                    case 0x0e: // Equals
                        var a = stack.pop();
                        var b = stack.pop();
                        a = (typeof a === 'number')?a:0;
                        b = (typeof b === 'number')?b:0;
                        if (a === b) {
                            stack.push(1); // SWF4
                            // Note: For SWF5, true is pushed.
                        } else {
                            stack.push(0);
                            // Note: For SWF5, false is pushed.
                        }
                        break;
                    case 0x17: // Pop
                        stack.pop(); // discards the value
                        break;
                    default:
                        console.debug("FlappActiom: not implemented yet. code=0x%02x", code);
                        break;
                    }
                }
            } else {
                switch (code) {
                case 0x1d: // SetVariables
                    movieClip.setVariable(stack.pop(), stack.pop());
                    break;
                default:
                    console.debug("FlappActiom: not implemented yet. code=0x%02x", code);
                    break;
                }
            }
        } else { // with Operand
            var actionLength = actionsBit.input(tag.actions);
            var nextActionOffset = actionsBit.getBytePos() + actionLength;
            if (code < 0x96) { // 0x96(Push)
                switch (code) {
                case 0x81: // GotoFrame
                    movieClip.gotoFrame(actionsBit.si16());
                    break;
                case 0x83: // GetURL
                    //
                    break;
                case 0x8c: // GoToLabel
                    movieClip.gotoLabel(actionsBit.strN(actionLength));
                    break;
                default:
                    console.debug("FlappActiom: not implemented yet. 0x"+code.toString(16));
                    break;
                }
            } else { // 0x96(Push)<=code
                switch (code) {
                case 0x96: // Push
                    //
                    break;
                case 0x99: // Jump
                    var branchOffset = actionsBit.si16();
                    actionsBit.seek(branchOffset, 0);
                    break;
                default:
                    console.debug("FlappActiom: not implemented yet. 0x"+code.toString(16));
                    break;
                }
            }
            actionsBit.setPos(nextActionOffset, 0);
        }
    }
};

});
