goog.provide('FlappShape');

goog.scope(function() {

/**
 * @constructor
 */
FlappShape = function(movieClip, matrix, colorTransform) {
    this.OBJECT_TYPE = 1; // 1:Shape, 2:MovieClip
    this.movieClip = movieClip;
    this.name = null;
    this.matrix = matrix;
    this.setMatrix(matrix);
    this.colorTransform = colorTransform;
    //    this.canvas = document.createElement('canvas');
    //    this.canvas.width = 240; // XXX
    //    this.canvas.height = 240; // XXX
    this.renderCode = ""; // new Function("ctx,dict", "ctx.line...")
};

FlappShape.prototype = {
    setMatrix: function(matrix) {
        this.matrix = matrix;
        this.absoluteMatrix = this.movieClip?(matrix?FlappSWFMatrix.multiply(this.movieClip.absoluteMatrix, matrix):this.movieClip.absoluteMatrix):matrix;
    },
    loadShapeTag: function(shape, dict) {
        var rca = []; // rca
        var fillStyles = shape.fillStyles;
        var lineStyles = shape.lineStyles;
        var fillEdges = shape.edges.fillEdges;
        var lineEdges = shape.edges.lineEdges;
        var factor = FlappSWFMatrix.maxAbsScaleSkew(this.absoluteMatrix);
        rca.push("var ctx = canvas.ctx;");
        for (var fillStyle in fillEdges) {
            // style
            var style = fillStyles[fillStyle - 1];
            //            console.log('style');
            //            console.log(style);
            //            console.log(fillStyle);
            //            console.log(fillStyles);
            var styleCode = null;
            var edgeInfoList = fillEdges[fillStyle];
            var minX = edgeInfoList.minX;
            var maxX = edgeInfoList.maxX;
            var minY = edgeInfoList.minY;
            var maxY = edgeInfoList.maxY;
            switch (style.type) {
            case 00:
                styleCode = '"'+FlappSWFRGBA.toCSS(style.color)+'"';
                break;
            case 0x40:
            case 0x41:
            case 0x42:
            case 0x43:
                if (style.bitmapId === 65535) {
                    // nothing to do
                } else {
                    var bitmap = dict.get(style.bitmapId);
                    var image = bitmap.image;
                    rca.push("var bitmap = dict.get("+style.bitmapId+");");
                    rca.push("var image = bitmap.image;");
                    rca.push("var canvas_im = document.createElement('canvas');");
                    var m_factor = [factor, 0, 0, factor, 0, 0];
                    var m = FlappSWFMatrix.multiply(style.matrix, m_factor);
                    m[4] = m[5] = 0;
                    var xy = FlappSWFMatrix.multiplyVector(m, image.width, image.height);
                    rca.push("canvas_im.size = " + xy[0] + ";");
                    rca.push("canvas_im.height = " + xy[1] + ";");
                    rca.push("var ctx_im = canvas_im.getContext('2d');");
                    rca.push("ctx_im.setTransform("+m[0]+","+m[1]+","+m[2]+","+m[3]+","+m[4]+","+m[5]+");");
                    rca.push("ctx_im.drawImage(image, 0, 0, image.width, image.height);");
                    if ((style.type === 0x40) || (style.type ===  0x42)) {
                        rca.push("var pattern = ctx.createPattern(canvas_im, 'repeat');");
                    } else {
                        rca.push("var pattern = ctx.createPattern(canvas_im, 'no-repeat');");
                    }
                    styleCode = "pattern";
                }
                break;
            }
            if (styleCode !== null) {
                rca.push("ctx.fillStyle = "+styleCode+";");
                //                rca.push("ctx.fillStyle = \"rgb(0, 255, 0)\";");
            }
            if (factor !== 1) {
                rca.push("ctx.save();");
                rca.push("ctx.transform("+1/factor+",0, 0, "+1/factor+", 0, 0);");
            }
            rca.push("ctx.translate("+minX*factor+","+minY*factor+");");
            var edgesUsed = new Uint8Array(edgeInfoList.length); // 0 initialized
            rca.push("ctx.beginPath();");
            for (var i1 = 0, l1 = edgeInfoList.length ; i1 < l1 ; i1++) {
                var edgeInfo = edgeInfoList[i1];
                var edges = edgeInfo.edges;
                if (edgeInfo.prev === null || edgeInfo.next === null) {
                    console.warn("edgeInfo.prev === null || edgeInfo.next === null");
                    continue;
                }
                if (edgesUsed[i1]) {
                    continue; // skip
                }
                var currIndex = i1;
                console.log(edgeInfo);
                // ref) http://d.hatena.ne.jp/yoya/20120313/canvas
                rca.push("ctx.moveTo("+(edges[0]-minX)*factor+","+(edges[1]-minY)*factor+");");
                do {
                    if (edgesUsed[currIndex]) {
                        console.error("duplicate link edge");
                        break;
                    }
                    edgeInfo = edgeInfoList[currIndex];
                    edges = edgeInfo.edges;
                    var types = edgeInfo.types;
                    edgesUsed[currIndex] = 1; // used
                    var types_index = 0;
                    for (var i2 = 2, l2 = edges.length ; i2 < l2; ) {
                        if (types[types_index++] === 'C') {
                            rca.push("ctx.quadraticCurveTo("+(edges[i2++]-minX)*factor+","+(edges[i2++]-minY)*factor+","+(edges[i2++]-minX)*factor+","+(edges[i2++]-minY)*factor+");");
                        } else {
                            rca.push("ctx.lineTo("+(edges[i2++]-minX)*factor+","+(edges[i2++]-minY)*factor+");");
                        }
                    }
                    if (currIndex === edgeInfo.next) {
                        break; // self loop
                    }
                } while ((currIndex = edgeInfo.next) !== null);
            }
            rca.push("ctx.fill();");
            if (factor !== 1) {
                rca.push("ctx.restore();");
            }
        }
        var m = [factor, 0, 0, factor, 0, 0];
        rca.push("ctx.save()");
        rca.push("ctx.setTransform("+m[0]+","+m[1]+","+m[2]+","+m[3]+","+m[4]+","+m[5]+");");
        for (var lineStyle in lineEdges) {
            var style = lineStyles[lineStyle - 1];
            var edgeInfoList = fillEdges[fillStyle];
            rca.push("ctx.lineWidth = "+style.width+";");
            styleCode = '"'+FlappSWFRGBA.toCSS(style.color)+'"';
            rca.push("ctx.strokeStyle = "+styleCode+";");
            rca.push("ctx.beginPath();");
	    for (var i1 = 0, l1 = edgeInfoList.length ; i1 < l1 ; i1++) {
                var edgeInfo = edgeInfoList[i1];
                var types = edgeInfo.types;
                var edges = edgeInfo.edges;
		var types_index = 0;
		for (var i2 = 0, l2 = edges.length ; i2 < l2 ; ) {
                    if (types[types_index++] === 'C') {
                        rca.push("ctx.quadraticCurveTo("+(edges[i2++]-minX)*factor+","+(edges[i2++]-minY)*factor+","+(edges[i2++]-minX)*factor+","+(edges[i2++]-minY)*factor+");");
                    } else {
                        rca.push("ctx.lineTo("+(edges[i2++]-minX)*factor+","+(edges[i2++]-minY)*factor+");");
                        }
		}
	    }
            rca.push("ctx.stroke();");
	}
        rca.push("ctx.restore()");
        this.renderCode = rca.join("\n");
        console.debug(this.renderCode);
    },
    render: function(canvas, dict) {
        //        debugger;
//        console.debug("FlappShape::render");
        canvas.setTransform(this.absoluteMatrix);
        var f = new Function("canvas,dict", this.renderCode);
        var ret = f(canvas, dict);
    },
    destroy: function(canvas) {
    }
};


FlappShape.shapetoRenderCode = function(shapeTag) {
    ;
};

});
