goog.provide('FlappString');

goog.scope(function() {

/**
 * @constructor
 */
FlappString = function() {
    ;
};

FlappString.SJISToUTF8Table = [];

FlappString.ArrayToString = function(sjisArray) {
    var strArray = [];
    for (var i = 0, l = sjisArray.length ; i < l ; i++) {
        strArray.push(String.fromCharCode(sjisArray[i]));
    }
    return strArray.join('');
};

FlappString.SJISArrayToString = function(sjisArray) {
    console.log("FlappString::SJISArrayToString");
    var string = FlappString.ArrayToString(sjisArray);
    if (string in FlappString.SJISToUTF8Table) {
        return string; 
    }
    FlappString.SJISToUTF8Table[string] = string; // dummy string
    var b = new Blob([sjisArray]);
    var fr = new FileReader();
    fr.onloadend = function() {
        FlappString.SJISToUTF8Table[string] = fr.result;
    };
    fr.readAsText(b, "sjis");

    return string;
};

FlappString.SJISToUTF8 = function(string) {
    if (string in FlappString.SJISToUTF8Table) {
        return FlappString.SJISToUTF8Table[string];
    }
    return null;
};

FlappString.SJISArrayMBLength = function(sjis){
    var len = 0;
    for (var i = 0, l = sjis.length ; i < l ; i++) {
        if (sjis[i] & 0x80) {
            i++;
        }
        len ++;
    }
    return len;
};

FlappString.SJISArrayMBExtract = function(sjis){
    var extractedSJIS = [];
    for (var i = 0, l = sjis.length ; i < l ; i++) {
        if (sjis[i] & 0x80) {
            extractedSJIS.join([sjis[i++], sjis[i]]);
        } else {
            extractedSJIS.join([sjis[i]]);
        }
    }
    return extractedSJIS;
}

});
