/*
  DefineShape parser
*/
goog.provide('FlappSWFTagDefineShape');
goog.require('FlappSWFShapeRecords');
goog.require('FlappSWFFillStyles');
goog.require('FlappSWFLineStyles');
goog.require('FlappSWFRect');

goog.scope(function() {

/**
 * @constructor
 */
FlappSWFTagDefineShape = function(code, length, ibit) {
//        console.log("FlappSWFTagDefineShape(code:"+code+", length:"+length+", ibit)");
    this.code = code;
    this.length = length;
    this.id = ibit.ui16();
    this.bounds = FlappSWFRect.load(ibit);
    var fillStyles = FlappSWFFillStyles.load(code, ibit);
    var lineStyles = FlappSWFLineStyles.load(code, ibit);
    ibit.a();
    var numBits = ibit.ui8();
    var numFillBits = numBits >> 4;
    var numLineBits = numBits & 0x0f;
    this.fillStyles = fillStyles;
    this.lineStyles = lineStyles;
    this.edges = FlappSWFShapeRecords.loadAndMarkEdgeLoop(code, ibit, fillStyles, lineStyles, numFillBits, numLineBits);
//     console.debug(this);
};

});
