unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms3D, FMX.Types3D, FMX.Forms, FMX.Graphics,
  FMX.Dialogs, System.Math.Vectors, FMX.Objects3D, FMX.Controls3D,
  FMX.MaterialSources, FMX.StdCtrls, FMX.Layers3D, Generics.Collections;

type
  TRec = record
    X, Y: Single;
    Z: Single;
  end;

  TForm1 = class(TForm3D)
    Light1: TLight;
    Cone1: TCone;
    Timer1: TTimer;
    LightMaterialSource1: TLightMaterialSource;
    Cube1: TCube;
    LightMaterialSource2: TLightMaterialSource;
    Text3D1: TText3D;
    procedure Timer1Timer(Sender: TObject);
    procedure Form3DKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure Form3DCreate(Sender: TObject);
    procedure Form3DDestroy(Sender: TObject);
  private
    { private 錾 }
    count: integer;
    Char: TList;
    Dummy: TComponent;
    rec: TList<TRec>;
    score: integer;
    procedure Start;
  public
    { public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

uses Math;

procedure TForm1.Form3DCreate(Sender: TObject);
begin
  Char := TList.Create;
  rec := TList<TRec>.Create;
  Start;
end;

procedure TForm1.Form3DDestroy(Sender: TObject);
begin
  Timer1.Enabled := false;
  Char.Free;
  Dummy.Free;
  rec.Free;
end;

procedure TForm1.Form3DKeyDown(Sender: TObject; var Key: Word;
  var KeyChar: Char; Shift: TShiftState);
begin
  case Key of
    vkleft:
      Cone1.RotationAngle.Z := Cone1.RotationAngle.Z - 5;
    vkright:
      Cone1.RotationAngle.Z := Cone1.RotationAngle.Z + 5;
    vkreturn:
      Start;
  end;
end;

procedure TForm1.Start;
begin
  Dummy.Free;
  Dummy := TComponent.Create(Form1);
  Char.Clear;
  Char.Add(Cone1);
  Cone1.Position.X := 0;
  Cone1.Position.Y := 0;
  Cube1.Position.X := 9 - Random(19);
  Cube1.Position.Y := 9 - Random(19);
  Randomize;
  score := 0;
  Timer1.Enabled := true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  s1: TCustomMesh;
  i: integer;
  s: TRec;
begin
  s.X := Cone1.Position.X;
  s.Y := Cone1.Position.Y;
  s.Z := Cone1.RotationAngle.Z;
  rec.Add(s);
  if rec.count > Char.count * 10 then
    rec.Delete(0);
  for i := 1 to Char.count - 1 do
  begin
    s1 := Char[i];
    if i * 10 > rec.count then
      continue;
    s := rec.Items[rec.count - i * 10];
    s1.Position.X := s.X;
    s1.Position.Y := s.Y;
    s1.RotationAngle.Z := s.Z;
    if s1.Visible = false then
      s1.Visible := true;
  end;
  Cone1.Position.X := Cone1.Position.X + 0.1 *
    cos(DegToRad(Cone1.RotationAngle.Z - 90));
  Cone1.Position.Y := Cone1.Position.Y + 0.1 *
    sin(DegToRad(Cone1.RotationAngle.Z - 90));
  if (Abs(Cone1.Position.X - Cube1.Position.X) < 1) and
    (Abs(Cone1.Position.Y - Cube1.Position.Y) < 1) and (Cube1.Visible = true)
  then
  begin
    Cube1.Visible := false;
    Cube1.Position.X := 9 - Random(19);
    Cube1.Position.Y := 9 - Random(19);
    s1 := TCube.Create(Dummy);
    s1.Visible := false;
    s1.MaterialSource := LightMaterialSource1;
    s1.Parent := Form1;
    Char.Add(s1);
    inc(score, 100);
  end;
  if Cube1.Visible = false then
    inc(count);
  if count > 50 then
  begin
    Cube1.Visible := true;
    count := 0;
  end;
  if (Cone1.Position.X < -10) or (Cone1.Position.X > 10) or
    (Cone1.Position.Y < -10) or (Cone1.Position.Y > 10) then
    Timer1.Enabled := false;
  for i := 2 to Char.count - 1 do
  begin
    s1 := TCustomMesh(Char[i]);
    if (Abs(Cone1.Position.X - s1.Position.X) < 1) and
      (Abs(Cone1.Position.Y - s1.Position.Y) < 1) and (s1.Visible = true) then
      Timer1.Enabled := false;
  end;
  inc(score, 10 * Char.count);
  Text3D1.Text := score.ToString;
end;

end.
