﻿using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using FooEditEngine.WPF;

namespace Test
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            this.fooTextBox.Hilighter = new XmlHilighter();
        }

        private void MenuItem_Click(object sender, RoutedEventArgs e)
        {
            this.fooTextBox.IsEnabled = true;
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_1(object sender, RoutedEventArgs e)
        {
            this.fooTextBox.IsEnabled = false;
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_2(object sender, RoutedEventArgs e)
        {
            PrintDialog pd = new PrintDialog();
            pd.PageRangeSelection = PageRangeSelection.AllPages;
            pd.UserPageRangeEnabled = true;
            if (pd.ShowDialog() == false)
                return;
            FooPrintText printtext = new FooPrintText();
            printtext.Document = this.fooTextBox.Document;
            printtext.Font = this.fooTextBox.FontFamily;
            printtext.FontSize = this.fooTextBox.FontSize;
            printtext.DrawLineNumber = true;//this.fooTextBox.DrawLineNumber;
            printtext.Header = "header";
            printtext.Footer = "footter";
            printtext.isWordRap = true;
            if (pd.PageRangeSelection == PageRangeSelection.AllPages)
            {
                printtext.StartPage = -1;
                printtext.EndPage = -1;
            }
            else
            {
                printtext.StartPage = pd.PageRange.PageFrom;
                printtext.EndPage = pd.PageRange.PageTo;
            }
            printtext.PageSize = new Size(pd.PrintableAreaWidth, pd.PrintableAreaHeight);
            printtext.Print(pd.PrintQueue,pd.PrintTicket);
        }
    }
}
