﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using Slusser.Collections.Generic;

namespace FooEditEngine
{
    /// <summary>
    /// ランダムアクセス可能な列挙子を提供するインターフェイス
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface IRandomEnumrator<T>
    {
        /// <summary>
        /// インデクサーを表す
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <returns>Tを返す</returns>
        T this[int index]{get;}
    }

    class StringBuffer : IEnumerable<char>,IRandomEnumrator<char>
    {
        GapBuffer<char> buf = new GapBuffer<char>();
        StringBuilder temp = new StringBuilder();
        bool _EnableFireUpdateEvent;

        public StringBuffer()
        {
            this.Selections = new SelectCollection();
            this._EnableFireUpdateEvent = true;
        }

        public char this[int index]
        {
            get
            {
                return buf[index];
            }
        }

        public string ToString(int index, int length)
        {
            this.temp.Clear();
            for (int i = index; i < index + length; i++)
                this.temp.Append(buf[i]);
            return this.temp.ToString();
        }

        public bool EnableFireUpdateEvent
        {
            get { return this._EnableFireUpdateEvent; }
            set
            {
                this._EnableFireUpdateEvent = value;
                if (value)
                {
                    this.Update(this, new DocumentUpdateEventArgs(UpdateType.Clear, -1, -1, -1));
                    this.Update(this, new DocumentUpdateEventArgs(UpdateType.Replace, 0, 0, this.Length));
                }
            }
        }

        public int Length
        {
            get { return this.buf.Count; }
        }

        internal SelectCollection Selections
        {
            get;
            private set;
        }

        internal event DocumentUpdateEventHandler Update;

        internal void Replace(int index, int length, string s)
        {
            if (length > 0)
                this.buf.RemoveRange(index, length);
            this.buf.InsertRange(index, s);
            if (this.EnableFireUpdateEvent)
                this.Update(this, new DocumentUpdateEventArgs(UpdateType.Replace, index, length, s.Length));
        }

        /// <summary>
        /// 文字列を削除する
        /// </summary>
        internal void Clear()
        {
            this.buf.Clear();
            this.Update(this, new DocumentUpdateEventArgs(UpdateType.Clear, -1, -1, -1));
        }

        #region IEnumerable<char> メンバー

        public IEnumerator<char> GetEnumerator()
        {
            for (int i = 0; i < this.Length; i++)
                yield return this[i];
        }

        #endregion

        #region IEnumerable メンバー

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            for (int i = 0; i < this.Length; i++)
                yield return this[i];
        }

        #endregion
    }
}