﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FooEditEngine;
using FooEditEngine.Windows;

namespace Test.Windows
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            this.fooTextBox1.ShowTab = true;
            this.fooTextBox1.ShowFullSpace = true;
            this.fooTextBox1.Hilighter = new XmlHilighter();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            FooPrintText fooPrint;
            fooPrint = new FooPrintText();
            fooPrint.Document = this.fooTextBox1.Document;
            fooPrint.DrawLineNumber = this.fooTextBox1.DrawLineNumber;
            fooPrint.Font = this.fooTextBox1.Font;
            fooPrint.isWordRap = this.fooTextBox1.LineBreak;
            fooPrint.Header = "header";
            fooPrint.Footer = "footer";
            PrintPreviewDialog dialog = new PrintPreviewDialog();
            dialog.Document = fooPrint.PrintDocument;
            dialog.Show();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (this.fooTextBox1.DrawLineNumber)
                this.fooTextBox1.DrawLineNumber = false;
            else
                this.fooTextBox1.DrawLineNumber = true;
            this.fooTextBox1.Refresh();
            this.fooTextBox1.Focus();
        }
    }
}
