﻿using System;
using SharpDX;
using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;

namespace FooEditEngine
{
    class InlineChar : DW.InlineObject
    {
        DW.TextLayout Layout;
        D2D.SolidColorBrush brush;  //キャッシュされたやつが渡されるのでDisposeする必要はない
        public InlineChar(DW.Factory factory, DW.TextFormat format,D2D.SolidColorBrush brush,char c)
        {
            this.Layout = new DW.TextLayout(factory,c.ToString(),format,float.MaxValue,float.MaxValue);
            this.Layout.ReadingDirection = DW.ReadingDirection.LeftToRight;
            this.AlternativeChar = c;
            this.brush = brush;
        }

        public char AlternativeChar
        {
            get;
            private set;
        }

        public virtual void Draw(object clientDrawingContext, DW.TextRenderer renderer, float originX, float originY, bool isSideways, bool isRightToLeft, ComObject clientDrawingEffect)
        {
            D2D.RenderTarget render = clientDrawingContext as D2D.RenderTarget;
            if (render == null)
                return;

            render.DrawTextLayout(
                new DrawingPointF(originX, originY),
                this.Layout,
                this.brush);
        }

        public virtual void GetBreakConditions(out DW.BreakCondition breakConditionBefore, out DW.BreakCondition breakConditionAfter)
        {
            breakConditionAfter = DW.BreakCondition.CanBreak;
            breakConditionBefore = DW.BreakCondition.CanBreak;
        }

        public virtual DW.InlineObjectMetrics Metrics
        {
            get
            {
                DW.InlineObjectMetrics value = new DW.InlineObjectMetrics();
                value.Height = this.Layout.Metrics.Height;
                value.Width = this.Layout.Metrics.Width;
                DW.LineMetrics[] lines = this.Layout.GetLineMetrics();
                value.Baseline = lines[0].Baseline;
                return value;
            }
        }

        public virtual DW.OverhangMetrics OverhangMetrics
        {
            get
            {
                DW.OverhangMetrics value = new DW.OverhangMetrics();
                DW.TextMetrics metrics = this.Layout.Metrics;
                value.Left = metrics.Left;
                value.Right = metrics.Left + metrics.Width;
                value.Top = metrics.Top;
                value.Bottom = metrics.Top + metrics.Height;
                return value;
            }
        }

        public virtual IDisposable Shadow
        {
            get;
            set;
        }

        public virtual void Dispose()
        {
            this.Layout.Dispose();
            return;
        }
    }

    class InlineTab : InlineChar
    {
        int TabCount;
        public InlineTab(DW.Factory factory, DW.TextFormat format,D2D.SolidColorBrush brush, char c,int count)
            : base(factory, format, brush, c)
        {
            this.TabCount = count;
        }

        public override DW.InlineObjectMetrics Metrics
        {
            get
            {
                DW.InlineObjectMetrics value = base.Metrics;
                value.Width *= TabCount;
                return value;
            }
        }
    }
}
