﻿using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.TextFormatting;

namespace FooEditEngine.WPF
{
    class TextLayout :  ITextLayout
    {
        List<TextLine> lines = new List<TextLine>();
        FontRendering fontRender;
        CustomTextSource textSource;
        double _width;
        public TextLayout(string s, FontFamily font, double fontSize,Brush fore,double width,TextAlignment align = TextAlignment.Left)
        {
            this.fontRender = new FontRendering(font, fontSize, fore, align);
            this.textSource = new CustomTextSource();
            this.textSource.Text = s;
            this.textSource.FontRendering = fontRender;
            this.textSource.EffectCollection = new TextEffectCollection();
            this.textSource.DecorationCollection = new List<TextDecorationInfo>();
            this._width = width;
            this.Disposed = false;
        }

        public FlowDirection FlowDirection
        {
            get;
            set;
        }

        public bool Disposed
        {
            get;
            private set;
        }

        public bool Invaild
        {
            get
            {
                return false;
            }
        }

        public IEnumerable<Marker> Markers
        {
            get;
            set;
        }

        public List<TextLine> Lines
        {
            get
            {
                this.CreateLine();
                return this.lines;
            }
        }

        public void SetTextEffect(TextEffect effect)
        {
            this.textSource.EffectCollection.Add(effect);
        }

        public void SetTextDecoration(int start, int count, TextDecorationCollection collection)
        {
            this.textSource.DecorationCollection.Add(new TextDecorationInfo(start, count, collection));
        }

        public void Draw(DrawingContext dc,double x,double y)
        {
            this.CreateLine();
            foreach (TextLine line in this.lines)
            {
                line.Draw(dc, new System.Windows.Point(x, y), InvertAxes.None);
            }
        }

        public void Dispose()
        {
            foreach (TextLine line in this.lines)
                line.Dispose();
            this.lines.Clear();
            this.Disposed = true;
        }

        void CreateLine()
        {
            TextFormatter formatter = TextFormatter.Create();

            if (textSource.Text.Length == 0)
            {
                TextLine myTextLine = formatter.FormatLine(
                    textSource,
                    0,
                    this._width,
                    new GenericTextParagraphProperties(fontRender, this.FlowDirection),
                    null);
                lines.Add(myTextLine);
            }
            else
            {
                int textStorePosition = 0;
                this.lines.Clear();
                while (textStorePosition < textSource.Text.Length)
                {
                    TextLine myTextLine = formatter.FormatLine(
                        textSource,
                        textStorePosition,
                        this._width,
                        new GenericTextParagraphProperties(fontRender, this.FlowDirection),
                        null);
                    lines.Add(myTextLine);
                    textStorePosition += myTextLine.Length;
                }
            }
        }

        public double Width
        {
            get { return this.Lines[0].Width; }
        }

        public double Height
        {
            get { return this.Lines[0].Height; }
        }

        public int GetIndexFromX(double x)
        {
            return 0;
        }

        public double GetWidthFromIndex(int index)
        {
            return 0;
        }

        public double GetXFromIndex(int index)
        {
            return 0;
        }

        public int AlignIndexToNearestCluster(int index, AlignDirection flow)
        {
            return 0;
        }

        public IList<TextBounds> GetTextBounds(int start, int length)
        {
            return this.Lines[0].GetTextBounds(start, length);
        }
    }
}
