﻿using System;
using System.Drawing;

namespace FooEditEngine
{
    internal enum LineType
    {
        Solid,
        Dot,
        DashDot,
        DashDotDot,
    }
    internal interface IGraphics
    {
        int LineHeight { get; }
        int TabWidthChar { get; set; }
        bool Initalized { get; }
        void BeginDraw(Graphics g);
        void EndDraw();
        void FillBackground(Color color);
        int GetStringWidth(string str);
        int GetStringWidth(string str, int maxwidth, out int fit);
        void DrawLine(int x, int y, int tox, int toy, int LineHeight,LineType lineType,Color ForeColor);
        void DrawString(string str, int str_width, Color ForeColor, Color BackColor, HilightType hilightType, ref int x, ref int y);
        void SetClipRect(Rectangle rect);
    }

}
