﻿using System;
using System.Collections.Generic;

namespace FooEditEngine.Windows
{
    class CacheManager<TKey,TValue> : ResourceManager<TKey,TValue>
    {
        Queue<TKey> queque = new Queue<TKey>();
        int maxCount = 100;

        public new void Add(TKey key, TValue value)
        {
            base.Add(key, value);
            if (base.Count >= maxCount)
            {
                TKey overflowedKey = queque.Dequeue();
                base.Remove(overflowedKey);
            }
            queque.Enqueue(key);
        }

        public new void Clear()
        {
            base.Clear();
            queque.Clear();
        }
    }
}
