﻿using System;

namespace FooEditEngine
{
    struct Rectangle2
    {
        public double X;
        public int Top;
        public double Width;
        public int Count;
        public int Bottom
        {
            get
            {
                return this.Top + this.Count - 1;
            }
        }
        public double Right
        {
            get
            {
                return this.X + this.Width;
            }
        }
        public Rectangle2(double x,int row, double width, int count)
        {
            this.X = x;
            this.Top = row;
            this.Count = count;
            this.Width = width;
        }
    }
    struct Point2
    {
        public double X;
        public int Row;
        public Point2(double x, int row)
        {
            this.X = x;
            this.Row = row;
        }
    }
    /// <summary>
    /// 文章の位置を示すクラス
    /// </summary>
    public struct TextPoint : IComparable<TextPoint>
    {
        /// <summary>
        /// 行番号
        /// </summary>
        public int row;
        /// <summary>
        /// 桁
        /// </summary>
        public int col;

        /// <summary>
        /// コンストラクター
        /// </summary>
        /// <param name="row">行番号</param>
        /// <param name="col">桁</param>
        public TextPoint(int row, int col)
        {
            this.row = row;
            this.col = col;
        }

        /// <summary>
        /// 比較演算子を実装します
        /// </summary>
        /// <param name="a">比較される方</param>
        /// <param name="b">比較対象</param>
        /// <returns>条件を満たすなら真</returns>
        public static bool operator <(TextPoint a, TextPoint b)
        {
            return a.CompareTo(b) == -1;
        }

        /// <summary>
        /// 比較演算子を実装します
        /// </summary>
        /// <param name="a">比較される方</param>
        /// <param name="b">比較対象</param>
        /// <returns>条件を満たすなら真</returns>
        public static bool operator <=(TextPoint a, TextPoint b)
        {
            return a.CompareTo(b) != 1;
        }

        /// <summary>
        /// 比較演算子を実装します
        /// </summary>
        /// <param name="a">比較される方</param>
        /// <param name="b">比較対象</param>
        /// <returns>条件を満たすなら真</returns>
        public static bool operator >(TextPoint a, TextPoint b)
        {
            return a.CompareTo(b) == 1;
        }

        /// <summary>
        /// 比較演算子を実装します
        /// </summary>
        /// <param name="a">比較される方</param>
        /// <param name="b">比較対象</param>
        /// <returns>条件を満たすなら真</returns>
        public static bool operator >=(TextPoint a, TextPoint b)
        {
            return a.CompareTo(b) != -1;
        }

        /// <summary>
        /// 比較演算子を実装します
        /// </summary>
        /// <param name="a">比較される方</param>
        /// <param name="b">比較対象</param>
        /// <returns>条件を満たすなら真</returns>
        public static bool operator ==(TextPoint a, TextPoint b)
        {
            return a.Equals(b);
        }

        /// <summary>
        /// 比較演算子を実装します
        /// </summary>
        /// <param name="a">比較される方</param>
        /// <param name="b">比較対象</param>
        /// <returns>条件を満たすなら真</returns>
        public static bool operator !=(TextPoint a, TextPoint b)
        {
            return !a.Equals(b);
        }

        /// <summary>
        /// 一致するかどうか
        /// </summary>
        /// <param name="o">比較対象</param>
        /// <returns>一致するなら真</returns>
        public override bool Equals(object o)
        {
            TextPoint b = (TextPoint)o;
            return this.col == b.col && this.row == b.row;
        }

        /// <summary>
        /// ハッシュを返す
        /// </summary>
        /// <returns>ハッシュを返す</returns>
        public override int GetHashCode()
        {
            int result = this.row.GetHashCode();
            result ^= this.col.GetHashCode();
            return result;
        }

        #region IComparable<TextPoint> メンバー

        /// <summary>
        /// 比較する
        /// </summary>
        /// <param name="other">比較対象となるTextPointオブジェクト</param>
        /// <returns>相対値を返す</returns>
        public int CompareTo(TextPoint other)
        {
            if (this.row == other.row && this.col == other.col)
                return 0;
            if (this.row < other.row)
                return -1;
            else if (this.row == other.row && this.col < other.col)
                return -1;
            else
                return 1;
        }

        #endregion
    }
}
