﻿using System;
using System.Windows.Input;

namespace FooEditEngine.WPF
{
    /// <summary>
    /// FooTextBox固有のコマンド
    /// </summary>
    public static class FooTextBoxCommands
    {
        /// <summary>
        /// 選択モードの切り替えを行います
        /// </summary>
        public static RoutedUICommand ToggleRectSelectMode = new RoutedUICommand("Toggle Rect Selection",
            "ToggleRectSelect", 
            typeof(FooTextBox),
            new InputGestureCollection(){new KeyGesture(Key.B,ModifierKeys.Control)});
        /// <summary>
        /// 表示方向の切り替えを行います
        /// </summary>
        public static RoutedUICommand ToggleFlowDirection = new RoutedUICommand("Toggle Flow Direction",
            "ToggleFlowDirection",
            typeof(FooTextBox),
            null);
        /// <summary>
        /// コードポイントと文字を相互変換します
        /// </summary>
        public static RoutedUICommand ToggleCodePoint = new RoutedUICommand("Toggle ToggleCodePoint",
            "ToggleCodePoint",
            typeof(FooTextBox),
            null);
    }
}
