﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows.Threading;
using FooEditEngine;
using FooEditEngine.WPF;
using Microsoft.Win32;

namespace Test
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            this.fooTextBox.MouseDoubleClick += new System.Windows.Input.MouseButtonEventHandler(fooTextBox_MouseDoubleClick);
            this.fooTextBox.ShowTab = true;
            this.fooTextBox.ShowFullSpace = true;
            this.fooTextBox.FoldingStrategy = new CharFoldingMethod('{', '}');
            this.Closed += MainWindow_Closed;
        }

        void MainWindow_Closed(object sender, System.EventArgs e)
        {
            this.fooTextBox.Document.Cancle();
        }

        void fooTextBox_MouseDoubleClick(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            FooMouseButtonEventArgs fe = (FooMouseButtonEventArgs)e;
            foreach (Marker m in this.fooTextBox.Document.GetMarkers(fe.Index))
            {
                if (m.hilight == HilightType.Url)
                {
                    MessageBox.Show(this.fooTextBox.Document.ToString(m.start, m.length));

                    fe.Handled = true;
                }
            }
        }

        private void MenuItem_Click(object sender, RoutedEventArgs e)
        {
            if (this.fooTextBox.IsEnabled)
                this.fooTextBox.IsEnabled = false;
            else
                this.fooTextBox.IsEnabled = true;
            this.Enable.IsChecked = this.fooTextBox.IsEnabled;
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_1(object sender, RoutedEventArgs e)
        {
            if (this.fooTextBox.DrawLineNumber)
                this.fooTextBox.DrawLineNumber = false;
            else
                this.fooTextBox.DrawLineNumber = true;
            this.ShowLineNumber.IsChecked = this.fooTextBox.DrawLineNumber;
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_2(object sender, RoutedEventArgs e)
        {
            PrintDialog pd = new PrintDialog();
            pd.PageRangeSelection = PageRangeSelection.AllPages;
            pd.UserPageRangeEnabled = true;
            if (pd.ShowDialog() == false)
                return;
            FooPrintText printtext = new FooPrintText();
            printtext.Document = this.fooTextBox.Document;
            printtext.Font = this.fooTextBox.FontFamily;
            printtext.FontSize = this.fooTextBox.FontSize;
            printtext.DrawLineNumber = this.fooTextBox.DrawLineNumber;
            printtext.Header = "header";
            printtext.Footer = "footter";
            printtext.LineBreakMethod = this.fooTextBox.LineBreakMethod;
            printtext.LineBreakCharCount = this.fooTextBox.LineBreakCharCount;
            printtext.MarkURL = true;
            printtext.Hilighter = this.fooTextBox.Hilighter;
            printtext.Foreground = this.fooTextBox.Foreground;
            printtext.URL = this.fooTextBox.URL;
            printtext.Comment = this.fooTextBox.Comment;
            printtext.Keyword1 = this.fooTextBox.Keyword1;
            printtext.Keyword2 = this.fooTextBox.Keyword2;
            printtext.Litral = this.fooTextBox.Literal;
            printtext.FlowDirection = this.fooTextBox.FlowDirection;
            if (pd.PageRangeSelection == PageRangeSelection.AllPages)
            {
                printtext.StartPage = -1;
                printtext.EndPage = -1;
            }
            else
            {
                printtext.StartPage = pd.PageRange.PageFrom;
                printtext.EndPage = pd.PageRange.PageTo;
            }
            printtext.PageRect = new Rect(0,0,pd.PrintableAreaWidth, pd.PrintableAreaHeight);
            printtext.Print(pd);
        }

        private async void MenuItem_Click_3(object sender, RoutedEventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            bool result = (bool)ofd.ShowDialog(this);
            if (result == true)
            {
                await this.fooTextBox.Document.LoadAsync(ofd.FileName, Encoding.Default);
                this.fooTextBox.Refresh();
            }
        }

        private void MenuItem_Click_4(object sender, RoutedEventArgs e)
        {
            if (this.fooTextBox.LineBreakMethod == LineBreakMethod.None)
                this.fooTextBox.LineBreakMethod = LineBreakMethod.PageBound;
            else
                this.fooTextBox.LineBreakMethod = LineBreakMethod.None;
            this.fooTextBox.PerfomLayouts();
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_5(object sender, RoutedEventArgs e)
        {
            Document doc = this.fooTextBox.Document;
            doc.Insert(0,"this is a pen");
            doc.SetMarker(Marker.Create(0, 4, HilightType.Sold));
            doc.SetMarker(Marker.Create(8, 1, HilightType.Select, 255, 128, 128, 128));
            doc.SetMarker(Marker.Create(10, 3, HilightType.Squiggle, 255, 255, 0, 0));
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_6(object sender, RoutedEventArgs e)
        {
            this.fooTextBox.FlowDirection = this.RTL.IsChecked ? FlowDirection.RightToLeft : FlowDirection.LeftToRight;
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_7(object sender, RoutedEventArgs e)
        {
            if (this.fooTextBox.Hilighter != null)
            {
                this.fooTextBox.Hilighter = null;
                this.fooTextBox.LayoutLineCollection.ClearHilight();
                this.XMLHilight.IsChecked = false;
            }
            else
            {
                this.fooTextBox.Hilighter = new XmlHilighter();
                this.fooTextBox.LayoutLineCollection.HilightAll();
                this.XMLHilight.IsChecked = true;
            }
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_9(object sender, RoutedEventArgs e)
        {
            this.fooTextBox.LayoutLineCollection.GenerateFolding();
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_8(object sender, RoutedEventArgs e)
        {
            if (this.fooTextBox.DrawRuler)
                this.fooTextBox.DrawRuler = false;
            else
                this.fooTextBox.DrawRuler = true;
            this.ShowRuler.IsChecked = this.fooTextBox.DrawRuler;
            this.fooTextBox.Refresh();
        }

        private async void MenuItem_Click_10(object sender, RoutedEventArgs e)
        {
            SaveFileDialog sfd = new SaveFileDialog();
            bool result = (bool)sfd.ShowDialog(this);
            if (result == true)
            {
                await this.fooTextBox.Document.SaveAsync(sfd.FileName,Encoding.Default,"\r\n");
                MessageBox.Show("complete");
            }
        }
    }
}
