﻿using System.Windows;
using System.Windows.Controls;
using FooEditEngine.WPF;

namespace FooEditor
{
    /// <summary>
    /// LineJumpDialog.xaml の相互作用ロジック
    /// </summary>
    public partial class LineJumpDialog : Window
    {
        public LineJumpDialog(FooTextBox textbox)
            : this()
        {
            this.Model = new LineJumpViewModel(textbox);
            this.DataContext = this.Model;
        }
        /// <summary>
        /// コンストラクター
        /// </summary>
        public LineJumpDialog()
        {
            InitializeComponent();
            this.DataContext = this;
        }

        LineJumpViewModel Model;

        private void OK_Click(object sender, RoutedEventArgs e)
        {
            var hasErros = Validation.GetErrors(this.JumpToTextBox);
            if (hasErros.Count == 0)
            {
                this.Model.JumpCaretCommand();
                this.Close();
            }
        }

        private void Cancle_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
