﻿using System;
using System.Globalization;
using System.Text;
using System.Windows.Data;
using EncodeDetect;
using FooEditEngine;
using FooEditor.Properties;

namespace FooEditor
{
    [ValueConversion(typeof(object), typeof(string))]
    public class ObjectToTypeStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter,
          CultureInfo culture)
        {
            return value.GetType().Name;
        }

        public object ConvertBack(object value, Type targetType, object parameter,
          CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
    [ValueConversion(typeof(string), typeof(string))]
    public class HilightTypeConverter : IValueConverter
    {
        public object Convert(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            string type = (string)value;
            if (type == null)
                return Resources.DocumetTypeNone;
            else
                return type;
        }

        public object ConvertBack(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            return Binding.DoNothing;
        }
    }

    [ValueConversion(typeof(LineFeedType), typeof(string))]
    public class LineFeedConverter : IValueConverter
    {
        public object Convert(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            LineFeedType type = (LineFeedType)value;
            switch (type)
            {
                case LineFeedType.CR:
                    return "CR";
                case LineFeedType.CRLF:
                    return "CRLF";
                case LineFeedType.LF:
                    return "LF";
            }
            return string.Empty;
        }

        public object ConvertBack(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            string str = (string)value;
            switch (str)
            {
                case "CR":
                    return LineFeedType.CR;
                case "LF":
                    return LineFeedType.LF;
                case "CRLF":
                    return LineFeedType.CRLF;
            }
            throw new ArgumentOutOfRangeException();
        }
    }

    [ValueConversion(typeof(TextPoint), typeof(string))]
    public class TextPointConverter : IValueConverter
    {
        public object Convert(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            TextPoint tp = (TextPoint)value;
            return string.Format(Resources.TextPointFormat,tp.row + 1,tp.col + 1);
        }

        public object ConvertBack(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            return Binding.DoNothing;
        }
    }

    [ValueConversion(typeof(Encoding), typeof(string))]
    public class EncodingConverter : IValueConverter
    {
        public object Convert(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            Encoding enc = (Encoding)value;
            return enc.EncodingName;
        }

        public object ConvertBack(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            return Binding.DoNothing;
        }
    }

    [ValueConversion(typeof(double), typeof(string))]
    public class RateConverter : IValueConverter
    {
        public object Convert(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            double v = (double)value;
            return string.Format(Resources.MagnificationPowerFormat,(int)(v * 100));
        }

        public object ConvertBack(object value, System.Type targetType, object parameter, CultureInfo culture)
        {
            return Binding.DoNothing;
        }
    }
}
