﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.VisualStudio.TestPlatform.UnitTestFramework;
using UITest = Microsoft.VisualStudio.TestPlatform.UnitTestFramework.AppContainer;
using FooEditor;
using FooEditEngine.Metro;
using System.Threading.Tasks;

namespace UnitTest
{
    [TestClass]
    public class AppTest
    {
        [TestMethod]
        public void LineJumpTest()
        {
            LineJumpViewModel vm = new LineJumpViewModel(new LineJumpView());
            vm.ToRow = 2;
            Assert.IsTrue(!vm.JumpCaretCommand());
            vm.ToRow = 0;
            Assert.IsTrue(vm.JumpCaretCommand());
            vm.ToRow = 3;
            Assert.IsTrue(vm.JumpCaretCommand());
        }

        [TestMethod]
        public void FindFlyoutTest()
        {
            FindFlyoutViewModel vm = new FindFlyoutViewModel(new FindFlyoutView());
            vm.FindHistroy = new System.Collections.ObjectModel.ObservableCollection<string>();

            //検索実行時に対象パターンが検索履歴に追加されるかを調べる
            const string Pattern = "foo";
            vm.FindPattern = Pattern;
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(vm.FindHistroy.Contains(Pattern));

            //全置換え実行時に対象パターンが検索履歴に追加されるかを調べる
            const string Pattern1 = "bar";
            vm.FindPattern = Pattern1;
            vm.ReplacePattern = string.Empty;
            vm.ReplaceAllCommand.Execute(null);
            Assert.IsTrue(vm.FindHistroy.Contains(Pattern));

            //検索履歴から選択したパターンが検索パターンになるかどうか            
            vm.SelectedFindPattern = Pattern;
            Assert.IsTrue(vm.FindPattern == Pattern);
        }

        [TestMethod]
        public void AppSettingTest()
        {
            AppSettings setting = new AppSettings();

            //グローバルの設定とは違う値にしないと動作をテストできない
            FileType type = new FileType("test", "test");
            type.NoInherit = true;
            type.IndentBySpace = true;
            type.LineBreakCount = 10;
            type.LineBreakMethod = FooEditEngine.LineBreakMethod.CharUnit;
            type.ShowFullSpace = true;
            type.ShowLineBreak = true;
            type.ShowLineNumber = true;
            type.ShowRuler = true;
            type.ShowTab = true;
            type.TabCharCount = 8;

            //FileTypeがnullの場合、グローバル設定が返ってくる
            setting.FileType = null;
            Assert.IsTrue(setting.IndentBySpace != type.IndentBySpace);
            Assert.IsTrue(setting.LineBreakCount != type.LineBreakCount);
            Assert.IsTrue(setting.LineBreakMethod != type.LineBreakMethod);
            Assert.IsTrue(setting.ShowFullSpace != type.ShowFullSpace);
            Assert.IsTrue(setting.ShowLineBreak != type.ShowLineBreak);
            Assert.IsTrue(setting.ShowLineNumber != type.ShowLineNumber);
            Assert.IsTrue(setting.ShowRuler != type.ShowRuler);
            Assert.IsTrue(setting.ShowTab != type.ShowTab);
            Assert.IsTrue(setting.TabChar != type.TabCharCount);

            //FileTypeが設定されている場合、FileTypeの設定が返ってくる
            setting.FileType = type;
            Assert.IsTrue(setting.IndentBySpace == type.IndentBySpace);
            Assert.IsTrue(setting.LineBreakCount == type.LineBreakCount);
            Assert.IsTrue(setting.LineBreakMethod == type.LineBreakMethod);
            Assert.IsTrue(setting.ShowFullSpace == type.ShowFullSpace);
            Assert.IsTrue(setting.ShowLineBreak == type.ShowLineBreak);
            Assert.IsTrue(setting.ShowLineNumber == type.ShowLineNumber);
            Assert.IsTrue(setting.ShowRuler == type.ShowRuler);
            Assert.IsTrue(setting.ShowTab == type.ShowTab);
            Assert.IsTrue(setting.TabChar == type.TabCharCount);

            //FileTypeが設定されていても引き継ぐ場合は、グローバルの設定が返ってくる
            setting.FileType.NoInherit = false;
            Assert.IsTrue(setting.IndentBySpace != type.IndentBySpace);
            Assert.IsTrue(setting.LineBreakCount != type.LineBreakCount);
            Assert.IsTrue(setting.LineBreakMethod != type.LineBreakMethod);
            Assert.IsTrue(setting.ShowFullSpace != type.ShowFullSpace);
            Assert.IsTrue(setting.ShowLineBreak != type.ShowLineBreak);
            Assert.IsTrue(setting.ShowLineNumber != type.ShowLineNumber);
            Assert.IsTrue(setting.ShowRuler != type.ShowRuler);
            Assert.IsTrue(setting.ShowTab != type.ShowTab);
            Assert.IsTrue(setting.TabChar != type.TabCharCount);
        }
    }

    class AppSettings : AppSettingsBase
    {
        Dictionary<string, object> settings = new Dictionary<string, object>();

        protected override void SetDefalutSetting()
        {
            if (GetGlobalEditorProperty("FontFamily") == null)
                SetGlobalEditorProperty("FontFamily", "Calibri");
            if (GetGlobalEditorProperty("FontSize") == null)
                SetGlobalEditorProperty("FontSize", 18.0);
            if (GetGlobalEditorProperty("TabChar") == null)
                SetGlobalEditorProperty("TabChar", 4);
            if (GetGlobalEditorProperty("IsRTL") == null)
                SetGlobalEditorProperty("IsRTL", false);
            if (GetGlobalEditorProperty("ShowLineBreak") == null)
                SetGlobalEditorProperty("ShowLineBreak", false);
            if (GetGlobalEditorProperty("ShowTab") == null)
                SetGlobalEditorProperty("ShowTab", false);
            if (GetGlobalEditorProperty("ShowFullSpace") == null)
                SetGlobalEditorProperty("ShowFullSpace", false);
            if (GetGlobalEditorProperty("ShowRuler") == null)
                SetGlobalEditorProperty("ShowRuler", false);
            if (GetGlobalEditorProperty("ShowLineNumber") == null)
                SetGlobalEditorProperty("ShowLineNumber", false);
            if (GetGlobalEditorProperty("ShowLineMarker") == null)
                SetGlobalEditorProperty("ShowLineMarker", false);
            if (GetGlobalEditorProperty("LineBreakMethod") == null)
                SetGlobalEditorProperty("LineBreakMethod", (int)FooEditEngine.LineBreakMethod.None);
            if (GetGlobalEditorProperty("LineBreakCount") == null)
                SetGlobalEditorProperty("LineBreakCount", 80);
            if (GetGlobalEditorProperty("ShowFoundPattern") == null)
                SetGlobalEditorProperty("ShowFoundPattern", false);
            if (GetGlobalEditorProperty("IndentBySpace") == null)
                SetGlobalEditorProperty("IndentBySpace", false);
            if (GetGlobalEditorProperty("TopMargin") == null)
                SetGlobalEditorProperty("TopMargin", 0);
            if (GetGlobalEditorProperty("RightMargin") == null)
                SetGlobalEditorProperty("RightMargin", 0);
            if (GetGlobalEditorProperty("BottomMargin") == null)
                SetGlobalEditorProperty("BottomMargin", 0);
            if (GetGlobalEditorProperty("LeftMargin") == null)
                SetGlobalEditorProperty("LeftMargin", 0);
            if (GetGlobalEditorProperty("Header") == null)
                SetGlobalEditorProperty("Header", "%f");
            if (GetGlobalEditorProperty("Footer") == null)
                SetGlobalEditorProperty("Footer", "-%p-");
        }

        protected override object GetGlobalEditorProperty(string name)
        {
            bool found;
            object value;
            found = this.settings.TryGetValue(name, out value);
            return found ? value : null;
        }

        protected override void SetGlobalEditorProperty(string name, object value)
        {
            this.settings[name] = value;
        }
    }

    class LineJumpView : ILineJumpView
    {

        public int CaretPostionRow
        {
            get { return 0; }
        }

        public int AvailableMaxRow
        {
            get { return 2; }
        }

        public void JumpCaret(int row)
        {
            return;
        }
    }

    class FindFlyoutView : IFindView
    {
        public void FindNext(string pattern, bool useregex, System.Text.RegularExpressions.RegexOptions opt)
        {
        }

        public void Replace(string newpattern, bool usegroup)
        {
        }

        public void ReplaceAll(string pattern, string newpattern, bool usegroup, bool useregex, System.Text.RegularExpressions.RegexOptions opt)
        {
        }

        public void Reset()
        {
        }
    }
}
