﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;
using System.Windows.Input;

namespace FooEditor
{
    class FileTypeDetailFlyoutViewModel : ViewModelBase
    {
        FileType _FileType;
        public FileType FileType
        {
            get
            {
                return this._FileType;
            }
            set
            {
                this._FileType = value;
                this.OnPropertyChanged();
            }
        }

        string _NewExtension;
        public string NewExtension
        {
            get
            {
                return this._NewExtension;
            }
            set
            {
                this._NewExtension = value;
                this.OnPropertyChanged();
            }
        }

        public ICommand RemoveCommand
        {
            get
            {
                return new DelegateCommand<string>((e) =>
                {
                    this.FileType.ExtensionCollection.Remove(e);
                });
            }
        }

        public ICommand AddCommand
        {
            get
            {
                return new DelegateCommand<string>((e) =>
                {
                    this.FileType.ExtensionCollection.Add(this.NewExtension);
                });
            }
        }
    }
}
