<?php
/**
 * system_login_password_AuthKeyImage
 * 
 * @package system
 * @copyright Copyright (c) 2011, framework-fpider Developer Team.
 * @link http://sourceforge.jp/projects/frameworkspider/
 * @author  Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 */
class system_login_password_AuthKeyImage extends spider_Model {
	/** 作成した一時画像ファイルのパス	*/
	var $temporary_image_path	= '';
	function system_login_password_AuthKeyImage(){
	}
	/**
	 * require models
	 */
	function getRequireModels() {
		return array(
		'spider.model.Session',
		'spider.model.Language',
		'spider.model.AutoEncode',
		'spider.model.Session',
		);
	}
	function execute( & $request ) {
		$password	= $request->getSession('util.tempolarypassword.password');
		if( strlen(trim($password)) == 0 ) {
			$request->addError('system.error.common.session.timeout','',array(),false,SPIDER_LOG_LEVEL_ERROR);
		} else if( function_exists('imagecreate') && function_exists('imagecolorallocate')
			&& function_exists('imagestring') ) {
			// GDが利用可能なら一時ファイルに画像を作成
			$this->temporary_image_path		= DIR_PATH_TMP.DIRECTORY_SEPARATOR.'util';
			if( !file_exists( $this->temporary_image_path ) ) {
				if( @mkdir( $this->temporary_image_path, SPIDER_PERMISSION_DATA_FOLDER ) ) {
					@chmod( $this->temporary_image_path, SPIDER_PERMISSION_DATA_FOLDER );
				}
			}
			$this->temporary_image_path		.= DIRECTORY_SEPARATOR . 'temporarypassword';
			if( !file_exists( $this->temporary_image_path ) ) {
				if( @mkdir( $this->temporary_image_path, SPIDER_PERMISSION_DATA_FOLDER ) ) {
					@chmod( $this->temporary_image_path, SPIDER_PERMISSION_DATA_FOLDER );
				}
			}
			$this->temporary_image_path		.= DIRECTORY_SEPARATOR.util_CharUtility::getRundomKey(24).'.jpg';
			
			$password_img			= @imagecreate(150, 30);
			$background_color_01	= imagecolorallocate($password_img, rand(220,255), rand(220,255), rand(220,255));
			$text_colors			= array();
			for( $i=0; $i<20; $i++) {
				array_push($text_colors, imagecolorallocate($password_img, rand(0,100), rand(0,100), rand(0,100)));
			}
			
			$fontFile	= null;
			if (is_dir(DIR_PATH_DATA)) {
				if ($dh = @opendir(DIR_PATH_DATA)) {
					while (($fileName = readdir($dh)) !== false) {
						if( preg_match('/\\.[tT][tT][fF]$/',$fileName) > 0 ) {
							$fontFile	= DIR_PATH_DATA.DIRECTORY_SEPARATOR.$fileName;
							break;
						}
					}
				}
			}
			if( !is_null($fontFile) && file_exists($fontFile) ) {
				for( $i=0; $i<8; $i++ ) {
					$fontSize	= rand(18,20);
					$angle		= rand(-35,35);
					$posX		= rand( 3+($i*25), 8+($i*25) );
					$posY		= rand(18,26);
					$color		= $text_colors[rand(0,count($text_colors)-1)];
					imagettftext($password_img, $fontSize, $angle, $posX, $posY, $color, $fontFile, substr($password,$i,1) );
				}
			} else {
				for( $i=0; $i<8; $i++ ) {
					$fontSize	= rand(3,5);
					$posX		= rand( 3+($i*25), 8+($i*25) );
					$posY		= rand(6,13);
					$color		= $text_colors[rand(0,count($text_colors)-1)];
					imagechar($password_img, $fontSize, $posX, $posY, substr($password,$i,1), $color );
				}
			}
			imagejpeg($password_img, $this->temporary_image_path);
			imagedestroy($password_img);

			$request->setResponseHeader( 'Content-Type', 'image/jpeg' );
			$request->setResponseHeader( 'Content-Disposition', 'inline; filename="'.basename($this->temporary_image_path).'"' );
			$request->setResponseHeader( 'Expires', 'Mon, 26 Jul 1997 05:00:00 GMT' );
			$request->setResponseHeader( 'Cache-Control', 'no-store, no-cache, must-revalidate' );
			$request->setResponseHeader( 'Cache-Control', 'pre-check=0, post-check=0, max-age=0' );
			$request->setResponseHeader( 'Pragma', 'no-cache' );
			$request->setResponseHeader( 'Expires', '0' );
			$request->setResponseFile( $this->temporary_image_path );
		} else {
			// GDが利用できないなら
			$request->addError('system.error.common.nogd',SPIDER_LOG_LEVEL_ERROR,array());
		}
	}
	/**
	 * ビジネスモデルの後処理を行います。
	 * このメソッドをオーバーライドすることにより、ビジネスモデルの後処理として実行されます。
	 * @param $request 
	 */
	function post_process( & $request ) {
		if( strlen(trim($this->temporary_image_path)) > 5 && file_exists( $this->temporary_image_path ) ){
			unlink($this->temporary_image_path);
		}
	}
}
?>