package jp.sourceforge.freegantt.locale;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Resource {

	final static String LANGUAGE_FILE_LOAD_ERROR_TITLE = "fatal error";
	final static String LANGUAGE_FILE_LOAD_ERROR_MESSAGE = "Language file loading error.";
	
	static Resource resource;
	Locale locale;
	Map<String, String> values = new HashMap<String, String>();
	
	public Resource(Locale locale) {
		this.locale = locale;
	}
	
	public void load() throws IOException, ParserConfigurationException, SAXException {
		InputStream in = null;
		try {
			in = new FileInputStream("locale" + File.separator + "language." + locale.getLanguage() + ".xml");
			
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(in);
			
			NodeList nodelist = doc.getDocumentElement().getChildNodes();
			for (int i=0; i<nodelist.getLength(); i++) {
				Node node = nodelist.item(i);
				if (!(node instanceof Element)) continue;
				Element ele = (Element)node;
				if (!values.containsKey(ele.getTagName())) {
					values.put(ele.getTagName(), ele.getTextContent());
				}
			}
		} finally {
			in.close();
		}

	}
	
	public String getValue(String key) {
		String result = values.get(key);
		return (result == null) ? "" : result;
	}
	
	public synchronized static Resource makeInstance(Locale locale) {
		resource = new Resource(locale);
		try {
			resource.load();
			return resource;
		} catch (IOException e) {
			JOptionPane.showMessageDialog(null,LANGUAGE_FILE_LOAD_ERROR_MESSAGE,LANGUAGE_FILE_LOAD_ERROR_TITLE,JOptionPane.ERROR_MESSAGE);
		} catch (ParserConfigurationException e) {
			JOptionPane.showMessageDialog(null,LANGUAGE_FILE_LOAD_ERROR_MESSAGE,LANGUAGE_FILE_LOAD_ERROR_TITLE,JOptionPane.ERROR_MESSAGE);
		} catch (SAXException e) {
			JOptionPane.showMessageDialog(null,LANGUAGE_FILE_LOAD_ERROR_MESSAGE,LANGUAGE_FILE_LOAD_ERROR_TITLE,JOptionPane.ERROR_MESSAGE);
		}
		return null;
	}
	
	public synchronized static Resource getInstance() {
		return resource;
	}
	
	public synchronized static String get(String key) {
		return getInstance().getValue(key);
	}
	
}
