package jp.sourceforge.freegantt.swing;

import java.util.ArrayList;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;

public class MemberTableModel implements TableModel {
	
	String[] columnNames = {"", "リソース名"};
	
	Project project;
	List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();
	
	public MemberTableModel(Project project) {
		this.project = project;
	}

	@Override
	public int getRowCount() {
		return project.getMembers().size() + 1;
	}

	@Override
	public int getColumnCount() {
		return columnNames.length;
	}

	@Override
	public String getColumnName(int columnIndex) {
		if (columnIndex >= columnNames.length) return "";
		return columnNames[columnIndex];
	}

	@Override
	public Class<?> getColumnClass(int columnIndex) {
		return String.class;
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return columnIndex > 0;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if (columnIndex == 0) return rowIndex + 1;
		if (rowIndex >= project.getMembers().size()) return null;
		return project.getMembers().get(rowIndex).getName();
	}

	@Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		if (rowIndex > project.getMembers().size()) return;
		if (columnIndex != 1) return;
		if (aValue == null || ((String)aValue).isEmpty()) return;
		
		if (rowIndex == project.getMembers().size()) {
			project.getMembers().add(new Member());
		}
		project.getMembers().get(rowIndex).setName((String)aValue);
		
		for (TableModelListener listener: tableModelListeners) {
			TableModelEvent e = new TableModelEvent(this, rowIndex, rowIndex, columnIndex, TableModelEvent.UPDATE);
			listener.tableChanged(e);
		}
	}

	@Override
	public void addTableModelListener(TableModelListener l) {
		tableModelListeners.add(l);
	}

	@Override
	public void removeTableModelListener(TableModelListener l) {
		tableModelListeners.remove(l);
	}

	
	public void fireTableChanged() {
		for (TableModelListener listener: tableModelListeners) {
			TableModelEvent e = new TableModelEvent(this, 0, 0, 0, TableModelEvent.UPDATE);
			listener.tableChanged(e);
		}
	}

}
