package jp.sourceforge.freegantt.data.model;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.freegantt.data.Project;

public class ProjectInfoModel {

	Project project;
	List<ProjectInfoChangedListener> listeners = new ArrayList<ProjectInfoChangedListener>();
	
	public ProjectInfoModel(Project project) {
		this.project = project;
	}

	public void addProjectInfoChangedListener(ProjectInfoChangedListener l) {
		listeners.add(l);
	}
	
	public void removeProjectInfoChangedListener(ProjectInfoChangedListener l) {
		listeners.remove(l);
	}
	
	public void fireProjectInfoChangedEvent() {
		for (ProjectInfoChangedListener listener: listeners) {
			listener.projectInfoChanged();
		}
	}
}
