package jp.sourceforge.freegantt.data.undo;

import java.util.List;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class InsertTaskEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 6954579936773863317L;

	Project project;
	int index;
	Task newTask;
	List<Integer> newRestrictionIndexes;
	
	public InsertTaskEdit(Project project, Task newTask, int index) {
		this.project = project;

		this.index = index;
		this.newTask = newTask.clone();
		newRestrictionIndexes = project.collectRestrictionIndexes(newTask);
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().removeIndex(index);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().insertTaskAtIndex(newTask, index);
		newTask.setRestrictions(project.collectTasksAtIndexes(newRestrictionIndexes));
	}

	@Override
	public void die() {
		super.die();
		project = null;
		newTask = null;
	}

}
