package jp.sourceforge.freegantt.data.undo;

import java.util.Calendar;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateAdditionalHolidayEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 764441346885765481L;

	Project project;
	Calendar newCalendar;
	Calendar oldCalendar;
	int index;
	
	public UpdateAdditionalHolidayEdit(Project project, Calendar calendar, int index) {
		this.project = project;
		this.newCalendar = (Calendar)calendar.clone();
		this.oldCalendar = project.getAdditionalHolidays().get(index);
		this.index = index;
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setAdditionalHoliday(oldCalendar, index);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setAdditionalHoliday(newCalendar, index);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		newCalendar = null;
		oldCalendar = null;
	}
	
}
