package jp.sourceforge.freegantt.data.undo;

import java.awt.Dimension;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateCellSizeEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 2567221722199853666L;
	
	Project project;
	Dimension oldCellSize;
	Dimension newCellSize;
	
	public UpdateCellSizeEdit(Project project, Dimension cellSize) {
		this.project = project;
		this.oldCellSize = project.getCellSize();
		this.newCellSize = (Dimension)cellSize.clone();
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setCellSize(oldCellSize);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setCellSize(newCellSize);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		oldCellSize = null;
		newCellSize = null;
	}
}
