package jp.sourceforge.freegantt.data.undo;

import java.util.List;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class UpdateTaskEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = -4925123071826232873L;

	Project project;
	
	int index;
	Task oldTask;
	Task newTask;
	List<Integer> oldRestrictionIndexes;
	List<Integer> newRestrictionIndexes;
	
	public UpdateTaskEdit(Project project, Task newTask, int index) {
		this.project = project;

		this.index = index;
		this.oldTask = project.getTaskAtIndex(index).clone();
		this.newTask = newTask.clone();
		oldRestrictionIndexes = project.collectRestrictionIndexes(oldTask);
		newRestrictionIndexes = project.collectRestrictionIndexes(newTask);
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setTaskAtIndex(oldTask, index);
		oldTask.setRestrictions(project.collectTasksAtIndexes(oldRestrictionIndexes));
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setTaskAtIndex(newTask, index);
		newTask.setRestrictions(project.collectTasksAtIndexes(newRestrictionIndexes));
	}

	@Override
	public void die() {
		super.die();
		project = null;
		oldTask = null;
		newTask = null;
	}
}
