package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateTaskTableWidthEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = -3395111570988527230L;

	Project project;
	int oldTaskTableWidth;
	int newTaskTableWidth;
	
	public UpdateTaskTableWidthEdit(Project project, int oldLoc, int newLoc) {
		this.project = project;
		this.oldTaskTableWidth = oldLoc;
		this.newTaskTableWidth = newLoc;
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setTaskTableWidth(project, newTaskTableWidth, oldTaskTableWidth);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setTaskTableWidth(project, oldTaskTableWidth, newTaskTableWidth);
	}

	@Override
	public void die() {
		super.die();
		project = null;
	}

}
