package jp.sourceforge.freegantt.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;

import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableColumn;

import jp.sourceforge.freegantt.data.Column;
import jp.sourceforge.freegantt.data.model.ProjectViewChangedListener;

public class GanttChartSplitPane extends JSplitPane {
	private static final long serialVersionUID = -8567327389185691533L;

	Application app;
	int openedDividerLocation = 0;
	int columnStickWidth = 8;

	public GanttChartSplitPane(Application app, int newOrientation) {
		super(newOrientation);
		this.app = app;
		GanttChartSplitPaneUI ui = new GanttChartSplitPaneUI();
		setUI(ui);
		ui.getDivider().addMouseListener(new DividerMouseListener());
		addPropertyChangeListener(new DividerLocationChangeListener());
		app.getProject().getProjectViewModel().addProjectViewChangedListener(new ProjectViewChangedHandler());
	}

	@Override
	public void setDividerLocation(int location) {
		super.setDividerLocation(location);
		app.getProject().getView().setTaskTableWidth(location);

		if (location > 10) {
			openedDividerLocation = location;
		}
	}

	@Override
	public int getMaximumDividerLocation() {
		int width = 48;
		for (Column column: app.getProject().getView().getColumns()) {
			width += column.getWidth();
		}
		
		return width <= 48 ? 0 : width;
	}

	class GanttChartSplitPaneUI extends BasicSplitPaneUI {
		public BasicSplitPaneDivider getDivider() {
			return divider;
		}
	}

	class DividerMouseListener implements MouseListener {
		int preDividerLocation = 0;
		
		@Override
		public void mouseClicked(MouseEvent e) {
			if (e.getClickCount() == 2) {
				int newLocation = (getDividerLocation() < 10 ? openedDividerLocation : 0);
				app.getProject().getController().setTaskTableWidth(app.getProject(), preDividerLocation, newLocation);
			}
		}

		@Override
		public void mousePressed(MouseEvent e) {
			preDividerLocation = getDividerLocation();
		}

		@Override
		public void mouseReleased(MouseEvent e) {
			if (preDividerLocation != getDividerLocation()) {
				app.getProject().getController().setTaskTableWidth(app.getProject(), preDividerLocation, getDividerLocation());
			}
		}

		@Override
		public void mouseEntered(MouseEvent e) {
		}

		@Override
		public void mouseExited(MouseEvent e) {
		}
	}

	class DividerLocationChangeListener implements PropertyChangeListener {
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			if (evt.getPropertyName().equals(
					JSplitPane.DIVIDER_LOCATION_PROPERTY)) {
				int maximumDividerLocation = getMaximumDividerLocation();
				if ((Integer) evt.getNewValue() > maximumDividerLocation) {
					setDividerLocation(maximumDividerLocation);
					return;
				}
				
				JTable table = app.getTaskListTable();
				if (table == null) return;
				List<TableColumn> columns = Collections.list(table.getColumnModel().getColumns());
				int width = 18;
				for (TableColumn column: columns) {
					width += column.getWidth();
					if ((Integer) evt.getNewValue() >= width - columnStickWidth && 
							(Integer) evt.getNewValue() <= width + columnStickWidth) {
						setDividerLocation(width);
					}
				}
			}
		}
	}
	
	class ProjectViewChangedHandler implements ProjectViewChangedListener {

		@Override
		public void projectViewChanged() {
			setDividerLocation(app.getProject().getView().getTaskTableWidth());
		}
		
	}
}
