package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.undo.CompoundEdit;

public class MemberTable extends JTable {
	private static final long serialVersionUID = -7685420882564431191L;

	Color borderColor = new Color(0xC0, 0xC0, 0xC0);

	Application app;
	
	public MemberTable(Application app, TableModel dm) {
		super(dm);
		this.app = app;
		setFillsViewportHeight(true);
		setColumnSelectionAllowed(false);
		setGridColor(borderColor);
		getTableHeader().setResizingAllowed(false);
		getTableHeader().setReorderingAllowed(false);
		registerKeyboardAction(new RemoveAction(), KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0), JComponent.WHEN_FOCUSED);
		registerKeyboardAction(app.getMenu().getUndoAction(), KeyStroke.getKeyStroke(KeyEvent.VK_Z, InputEvent.CTRL_DOWN_MASK), JComponent.WHEN_FOCUSED);
		registerKeyboardAction(app.getMenu().getRedoAction(), KeyStroke.getKeyStroke(KeyEvent.VK_Y, InputEvent.CTRL_DOWN_MASK), JComponent.WHEN_FOCUSED);
		
		getColumnModel().getColumn(0).setCellRenderer(getTableHeader().getDefaultRenderer());
		columnModel.getColumn(0).setPreferredWidth(32);
		columnModel.getColumn(0).setMaxWidth(32);
		columnModel.getColumn(0).setMinWidth(32);
	}
	
	class RemoveAction extends AbstractAction {
		private static final long serialVersionUID = -7312387923027032759L;

		@Override
		public void actionPerformed(ActionEvent e) {
			CompoundEdit compound = new CompoundEdit();
			app.getProject().getUndoManager().addEdit(compound);
			try {
				int deleted = 0;
				int[] rows = getSelectedRows();
				for (int row: rows) {
					app.getProject().getController().removeMember(row - deleted);
					deleted ++;
				}
			} finally {
				compound.end();
			}
		}
	}
}
