package jp.sourceforge.freegantt.swing;

import java.awt.Container;
import java.util.Calendar;

import javax.swing.JPanel;
import javax.swing.JViewport;

import jp.sourceforge.freegantt.util.CalendarUtil;

public class TaskLinePane extends JPanel {
	private static final long serialVersionUID = 843023457646014650L;
	
	Application app;
	/**　描画範囲開始日 */
	Calendar chartFromDate;
	/** 描画範囲終了日 */
	Calendar chartToDate;

	public TaskLinePane(Application app) {
		this.app = app;
		
		chartFromDate = (Calendar)app.getProject().getChartRangeFromDate().clone();
		chartToDate = (Calendar)app.getProject().getChartRangeToDate().clone();
		updateChartRange();
		updateSize();
	}
	
	public void updateChartRange() {
		Calendar fromDate = (Calendar)chartFromDate.clone();
		Calendar toDate = (Calendar)chartToDate.clone();
		
		// タスクが全範囲含まれることを保証する
		Calendar projectFromDate = (Calendar)app.getProject().getChartRangeFromDate().clone();
		Calendar projectToDate = (Calendar)app.getProject().getChartRangeToDate().clone();
		projectFromDate.add(Calendar.MONTH, -1);
		projectToDate.add(Calendar.MONTH, 1);
		if (fromDate.getTimeInMillis() > projectFromDate.getTimeInMillis()) {
			fromDate = projectFromDate;
		}
		if (toDate.getTimeInMillis() < projectToDate.getTimeInMillis()) {
			toDate = projectToDate;
		}
		
		// ビューポートが全範囲含まれることを保証する
		Container viewport = getParent();
		if (viewport != null && viewport instanceof JViewport) {
			Calendar widthCoveredToDate = (Calendar)app.getProject().getChartRangeFromDate().clone();
			int viewportWidth = ((JViewport)viewport).getWidth();
			System.out.println(viewportWidth);
			widthCoveredToDate.add(Calendar.DATE, viewportWidth / getCellWidth());
			widthCoveredToDate.add(Calendar.MONTH, 1);
			if (toDate.getTimeInMillis() < widthCoveredToDate.getTimeInMillis()) {
				toDate = widthCoveredToDate;
			}
		}
		
		chartFromDate = CalendarUtil.toDateCalendar(fromDate);
		chartToDate = CalendarUtil.toDateCalendar(toDate);
	}
	
	public void updateSize() {
		int rowCount = app.getProject().getRowCount();

		int width = CalendarUtil.subDate(chartToDate, chartFromDate) * getCellWidth();
		int height = rowCount * getCellHeight() + getHeaderHeight();
		System.out.println("TaskLinePane updateSize done: " + width + "," + height);
		setSize(width, height);
		setPreferredSize(getSize());
	}
	
	public int getCellWidth() {
		return app.getProject().getCellSize().width;
	}
	
	public int getCellHeight() {
		return app.getProject().getCellSize().height;
	}
	
	public int getHeaderHeight() {
		return getCellHeight() * 2;
	}
	
	public Calendar getChartFromDate() {
		return chartFromDate;
	}
	
	public void setChartFromDate(Calendar calendar) {
		this.chartFromDate = calendar;
	}
	
	public Calendar getChartToDate() {
		return chartToDate;
	}
	
	public void setChartToDate(Calendar calendar) {
		this.chartToDate = calendar;
	}

	@Override
	public void doLayout() {
		System.out.println("TaskLinePane doLayout: ");
		
		super.doLayout();

		updateChartRange();
	}
	
	
}
