package jp.sourceforge.freegantt.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;

import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class TaskNameCellRenderer extends DefaultTableCellRenderer {
	private static final long serialVersionUID = -1820480136651683438L;

	final public static int INDENT_WIDTH = 16;
	JTable table;
	Component component;
	Project project;
	Task task;
	Image foldClosedImage;
	Image foldOpenedImage;
	FoldBorder foldBorder;
	
	public TaskNameCellRenderer(Project project) {
		this.project = project;
		foldClosedImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("fold_closed.png"));
		foldOpenedImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("fold_opened.png"));
		this.foldBorder = new FoldBorder(new Insets(1, 1, 1, 1));
	}

	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
				row, column);
		this.table = table;
		this.component = component;
		task = project.getTaskAtRow(row);
		if (task == null) return component;
		
		setBorder(foldBorder);
	
		return component;
	}
	
	class FoldBorder implements Border {
		
		Insets insets;
		
		public FoldBorder(Insets insets) {
			this.insets = insets;
		}
		
		public Rectangle getFoldRect() {
			if (!task.isGroup()) return null;
			
			int offsetLeft = getBorderInsets(component).left;
			return new Rectangle(
					offsetLeft - foldOpenedImage.getWidth(null) - 3,
					3,
					foldOpenedImage.getWidth(null),
					foldOpenedImage.getHeight(null));
		}

		@Override
		public void paintBorder(Component c, Graphics g, int x, int y,
				int width, int height) {
			Rectangle foldRect = getFoldRect();
			if (foldRect != null) {
				g.drawImage(task.isOpened() ? foldOpenedImage : foldClosedImage, foldRect.x, foldRect.y, table);
			}
		}

		@Override
		public Insets getBorderInsets(Component c) {
			Insets result = (Insets)insets.clone();
			if (task.isGroup()) result.left += 15;
			result.left += task.getLevel() * INDENT_WIDTH;
			return result;
		}

		@Override
		public boolean isBorderOpaque() {
			return false;
		}
		
	}
}
